(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    375787,      10171]*)
(*NotebookOutlinePosition[    376885,      10208]*)
(*  CellTagsIndexPosition[    376794,      10202]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[
"An example of plotting \ndirection fields and sample solutions. "], 
  "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"The differential equation has the form  dy/dt = f[t, y] or, as used below,  \
y'[t] = f[t, y[t]]. You may change the definition of f[t, y] and the various \
ranges of  t  and  y."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["The right hand side of the differential equation"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[t_, y_] = Exp[\(-\(\(3\ t\)\/2\)\)] - 3\ y + 3\/2\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(3\/2 + \[ExponentialE]\^\(\(\(-3\)\ t\)/2\) - 3\ y\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["The direction field"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["How is SlopeLines invoked?"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Information["\<SlopeLines\>", LongForm \[Rule] False]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("SlopeLines[f,length,{t,t0,t1,dt},{y,y0,y1,dy}] gives an array of lines \
showing the solutions to the differential equation dy/dt = f. The lengths of \
the slope lines at each grid point are given by length; t0, t1, and dt give \
the range {t0 to t1}and step-size for the t-values, and similarly for the \
y-values."\)], "Print",
  CellTags->"Info3279866828-6568912"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Plot the direction field."], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(field = 
        SlopeLines[
          f[t, y],  .15, {t, \(-2\), 3,  .25}, {y, \(-1\), 
            3,  .25}];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81672 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.399807 0.187442 0.220934 0.187442 [
[.02492 .20843 -6.75 -10 ]
[.02492 .20843 6.75 0 ]
[.21237 .20843 -6.75 -10 ]
[.21237 .20843 6.75 0 ]
[.58725 .20843 -4 -10 ]
[.58725 .20843 4 0 ]
[.77469 .20843 -4 -10 ]
[.77469 .20843 4 0 ]
[.96213 .20843 -4 -10 ]
[.96213 .20843 4 0 ]
[.38731 .03349 -13.5 -5 ]
[.38731 .03349 0 5 ]
[.38731 .40838 -8 -5 ]
[.38731 .40838 0 5 ]
[.38731 .59582 -8 -5 ]
[.38731 .59582 0 5 ]
[.38731 .78326 -8 -5 ]
[.38731 .78326 0 5 ]
[ 0 0 0 0 ]
[ 1 .81672 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02492 .22093 m
.02492 .22718 L
s
gsave
.02492 .20843 -67.75 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.500 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.21237 .22093 m
.21237 .22718 L
s
gsave
.21237 .20843 -67.75 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.500 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.58725 .22093 m
.58725 .22718 L
s
gsave
.58725 .20843 -65 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.77469 .22093 m
.77469 .22718 L
s
gsave
.77469 .20843 -65 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.96213 .22093 m
.96213 .22718 L
s
gsave
.96213 .20843 -65 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.125 Mabswid
.06241 .22093 m
.06241 .22468 L
s
.0999 .22093 m
.0999 .22468 L
s
.13739 .22093 m
.13739 .22468 L
s
.17488 .22093 m
.17488 .22468 L
s
.24985 .22093 m
.24985 .22468 L
s
.28734 .22093 m
.28734 .22468 L
s
.32483 .22093 m
.32483 .22468 L
s
.36232 .22093 m
.36232 .22468 L
s
.4373 .22093 m
.4373 .22468 L
s
.47478 .22093 m
.47478 .22468 L
s
.51227 .22093 m
.51227 .22468 L
s
.54976 .22093 m
.54976 .22468 L
s
.62474 .22093 m
.62474 .22468 L
s
.66223 .22093 m
.66223 .22468 L
s
.69971 .22093 m
.69971 .22468 L
s
.7372 .22093 m
.7372 .22468 L
s
.81218 .22093 m
.81218 .22468 L
s
.84967 .22093 m
.84967 .22468 L
s
.88716 .22093 m
.88716 .22468 L
s
.92464 .22093 m
.92464 .22468 L
s
.99962 .22093 m
.99962 .22468 L
s
.25 Mabswid
0 .22093 m
1 .22093 L
s
.39981 .03349 m
.40606 .03349 L
s
gsave
.38731 .03349 -74.5 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.500 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.39981 .40838 m
.40606 .40838 L
s
gsave
.38731 .40838 -69 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.39981 .59582 m
.40606 .59582 L
s
gsave
.38731 .59582 -69 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.39981 .78326 m
.40606 .78326 L
s
gsave
.38731 .78326 -69 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.125 Mabswid
.39981 .07098 m
.40356 .07098 L
s
.39981 .10847 m
.40356 .10847 L
s
.39981 .14596 m
.40356 .14596 L
s
.39981 .18345 m
.40356 .18345 L
s
.39981 .25842 m
.40356 .25842 L
s
.39981 .29591 m
.40356 .29591 L
s
.39981 .3334 m
.40356 .3334 L
s
.39981 .37089 m
.40356 .37089 L
s
.39981 .44586 m
.40356 .44586 L
s
.39981 .48335 m
.40356 .48335 L
s
.39981 .52084 m
.40356 .52084 L
s
.39981 .55833 m
.40356 .55833 L
s
.39981 .63331 m
.40356 .63331 L
s
.39981 .6708 m
.40356 .6708 L
s
.39981 .70828 m
.40356 .70828 L
s
.39981 .74577 m
.40356 .74577 L
s
.25 Mabswid
.39981 0 m
.39981 .81672 L
s
.0005 w
.02435 .01945 m
.02549 .04754 L
s
.02433 .06631 m
.02551 .0944 L
s
.02431 .11317 m
.02553 .14126 L
s
.02429 .16003 m
.02555 .18812 L
s
.02427 .20689 m
.02557 .23498 L
s
.02425 .25375 m
.0256 .28184 L
s
.02422 .30061 m
.02562 .3287 L
s
.0242 .34748 m
.02565 .37556 L
s
.02417 .39434 m
.02568 .42241 L
s
.02414 .4412 m
.02571 .46927 L
s
.0241 .48806 m
.02574 .51613 L
s
.02406 .53493 m
.02578 .56299 L
s
.02402 .58179 m
.02582 .60985 L
s
.02398 .62865 m
.02587 .65671 L
s
.02393 .67552 m
.02592 .70356 L
s
.02387 .72238 m
.02597 .75042 L
s
.02381 .76925 m
.02604 .79727 L
s
.07102 .01946 m
.07255 .04753 L
s
.07098 .06632 m
.07258 .09439 L
s
.07095 .11318 m
.07262 .14125 L
s
.07091 .16004 m
.07266 .1881 L
s
.07087 .20691 m
.0727 .23496 L
s
.07082 .25377 m
.07275 .28182 L
s
.07077 .30063 m
.0728 .32868 L
s
.07071 .3475 m
.07286 .37553 L
s
.07064 .39436 m
.07292 .42239 L
s
.07057 .44123 m
.073 .46924 L
s
.07049 .4881 m
.07308 .5161 L
s
.07039 .53497 m
.07317 .56295 L
s
.07028 .58184 m
.07329 .6098 L
s
.07015 .62872 m
.07342 .65664 L
s
.07 .6756 m
.07357 .70348 L
s
.06981 .72248 m
.07376 .75032 L
s
.06958 .76938 m
.07399 .79714 L
s
.11764 .01947 m
.11965 .04751 L
s
.11759 .06633 m
.1197 .09437 L
s
.11752 .1132 m
.11977 .14123 L
s
.11745 .16007 m
.11984 .18808 L
s
.11737 .20693 m
.11992 .23493 L
s
.11728 .2538 m
.12001 .28179 L
s
.11717 .30067 m
.12012 .32864 L
s
.11705 .34755 m
.12024 .37548 L
s
.1169 .39443 m
.12039 .42233 L
s
.11672 .44131 m
.12057 .46916 L
s
.1165 .4882 m
.12079 .51599 L
s
.11623 .53511 m
.12106 .56281 L
s
.11588 .58203 m
.12141 .6096 L
s
.11542 .629 m
.12187 .65636 L
s
.11477 .67603 m
.12252 .70305 L
s
.11382 .7232 m
.12347 .7496 L
s
.11233 .7707 m
.12496 .79582 L
s
.16423 .01949 m
.16677 .04749 L
s
.16414 .06636 m
.16687 .09434 L
s
.16404 .11323 m
.16697 .14119 L
s
.16391 .16011 m
.1671 .18804 L
s
.16377 .20698 m
.16724 .23488 L
s
.16359 .25387 m
.16742 .28172 L
s
.16337 .30076 m
.16764 .32855 L
s
.1631 .34766 m
.1679 .37537 L
s
.16276 .39459 m
.16825 .42216 L
s
.1623 .44155 m
.16871 .46892 L
s
.16166 .48857 m
.16935 .51562 L
s
.16073 .53573 m
.17028 .56218 L
s
.15927 .58322 m
.17174 .60842 L
s
.15681 .63163 m
.1742 .65373 L
s
.15304 .68305 m
.17797 .69603 L
s
.1518 .73954 m
.17921 .73326 L
s
.15546 .7931 m
.17555 .77342 L
s
.21081 .01952 m
.21392 .04746 L
s
.21067 .0664 m
.21406 .09431 L
s
.2105 .11328 m
.21423 .14115 L
s
.2103 .16017 m
.21443 .18798 L
s
.21005 .20707 m
.21468 .2348 L
s
.20973 .25399 m
.215 .2816 L
s
.2093 .30093 m
.21543 .32838 L
s
.20873 .34794 m
.216 .37509 L
s
.20789 .39505 m
.21684 .4217 L
s
.20662 .44241 m
.21811 .46807 L
s
.2045 .49044 m
.22023 .51375 L
s
.20102 .54066 m
.22371 .55726 L
s
.19831 .59608 m
.22642 .59556 L
s
.20122 .65124 m
.22351 .63411 L
s
.20463 .70128 m
.2201 .6778 L
s
.20669 .74926 m
.21804 .72354 L
s
.20794 .79661 m
.21679 .76992 L
s
.25739 .01955 m
.26106 .04743 L
s
.25719 .06644 m
.26126 .09426 L
s
.25694 .11334 m
.26151 .14109 L
s
.25663 .16026 m
.26182 .18789 L
s
.25623 .2072 m
.26222 .23467 L
s
.25567 .25419 m
.26278 .2814 L
s
.25488 .30128 m
.26357 .32803 L
s
.25368 .3486 m
.26477 .37443 L
s
.25171 .3965 m
.26674 .42026 L
s
.24841 .44626 m
.27004 .46422 L
s
.24521 .50097 m
.27324 .50322 L
s
.24755 .55678 m
.27091 .54113 L
s
.25113 .60731 m
.26732 .58432 L
s
.25334 .65545 m
.26511 .62991 L
s
.25467 .70284 m
.26378 .67624 L
s
.25553 .74996 m
.26292 .72284 L
s
.25612 .79697 m
.26233 .76955 L
s
.30399 .01959 m
.30819 .04739 L
s
.30372 .06649 m
.30845 .09421 L
s
.30339 .11342 m
.30878 .14101 L
s
.30295 .16037 m
.30922 .18778 L
s
.30234 .20738 m
.30983 .23448 L
s
.30146 .25452 m
.31072 .28107 L
s
.30008 .30194 m
.31209 .32737 L
s
.29779 .35017 m
.31439 .37286 L
s
.29412 .40099 m
.31805 .41576 L
s
.29215 .45709 m
.32002 .45338 L
s
.29555 .5114 m
.31662 .49279 L
s
.29874 .56095 m
.31343 .53697 L
s
.30065 .60878 m
.31153 .58286 L
s
.30181 .65607 m
.31036 .62929 L
s
.30258 .70315 m
.30959 .67593 L
s
.30312 .75014 m
.30905 .72266 L
s
.30352 .79708 m
.30865 .76944 L
s
.35062 .01963 m
.35527 .04736 L
s
.35029 .06655 m
.3556 .09416 L
s
.34987 .1135 m
.35603 .14093 L
s
.34928 .1605 m
.35661 .18765 L
s
.34844 .20762 m
.35745 .23425 L
s
.34714 .25499 m
.35875 .2806 L
s
.34498 .30307 m
.36091 .32624 L
s
.34146 .35342 m
.36444 .36962 L
s
.3389 .40901 m
.36699 .40774 L
s
.34194 .46399 m
.36395 .44649 L
s
.34531 .5139 m
.36059 .4903 L
s
.34733 .56185 m
.35856 .53607 L
s
.34856 .60917 m
.35733 .58246 L
s
.34936 .65627 m
.35653 .62908 L
s
.34993 .70327 m
.35597 .67581 L
s
.35034 .75021 m
.35556 .72259 L
s
.35065 .79713 m
.35524 .76939 L
s
.39729 .01966 m
.40232 .04732 L
s
.39691 .0666 m
.4027 .09411 L
s
.3964 .11357 m
.40322 .14085 L
s
.39567 .16064 m
.40394 .18751 L
s
.39459 .20788 m
.40503 .23399 L
s
.39283 .25559 m
.40678 .28 L
s
.38987 .30471 m
.40975 .3246 L
s
.38617 .35811 m
.41345 .36493 L
s
.38723 .41466 m
.41238 .40209 L
s
.39103 .46621 m
.40859 .44426 L
s
.39352 .51467 m
.40609 .48952 L
s
.395 .56217 m
.40461 .53575 L
s
.39595 .60934 m
.40367 .5823 L
s
.39659 .65636 m
.40303 .62899 L
s
.39705 .70332 m
.40256 .67575 L
s
.3974 .75025 m
.40222 .72255 L
s
.39767 .79716 m
.40194 .76937 L
s
.44401 .01969 m
.44933 .0473 L
s
.44358 .06664 m
.44976 .09407 L
s
.44299 .11365 m
.45035 .14078 L
s
.44214 .16077 m
.4512 .18738 L
s
.44082 .20815 m
.45251 .23372 L
s
.43864 .25625 m
.4547 .27933 L
s
.43508 .30669 m
.45825 .32262 L
s
.43264 .3624 m
.4607 .36064 L
s
.43576 .41724 m
.45758 .39951 L
s
.43909 .46708 m
.45424 .4434 L
s
.44109 .515 m
.45225 .48919 L
s
.4423 .56232 m
.45103 .53559 L
s
.4431 .60942 m
.45023 .58222 L
s
.44366 .65641 m
.44968 .62895 L
s
.44407 .70335 m
.44927 .67572 L
s
.44438 .75027 m
.44896 .72253 L
s
.44463 .79717 m
.44871 .76935 L
s
.49076 .01971 m
.4963 .04727 L
s
.49029 .06667 m
.49677 .09403 L
s
.48964 .1137 m
.49742 .14072 L
s
.48868 .16088 m
.49838 .18727 L
s
.48717 .2084 m
.49989 .23347 L
s
.48463 .25691 m
.50243 .27868 L
s
.48082 .30865 m
.50624 .32066 L
s
.47998 .36528 m
.50707 .35776 L
s
.48372 .41845 m
.50333 .3983 L
s
.48664 .46749 m
.50042 .44298 L
s
.48836 .51517 m
.4987 .48903 L
s
.48943 .5624 m
.49763 .53551 L
s
.49014 .60946 m
.49692 .58217 L
s
.49065 .65644 m
.49641 .62892 L
s
.49103 .70337 m
.49603 .67571 L
s
.49132 .75028 m
.49574 .72252 L
s
.49155 .79718 m
.49551 .76934 L
s
.53754 .01973 m
.54324 .04726 L
s
.53704 .0667 m
.54374 .09401 L
s
.53634 .11375 m
.54444 .14068 L
s
.5353 .16097 m
.54548 .18718 L
s
.53363 .20861 m
.54715 .23326 L
s
.53081 .2575 m
.54997 .27809 L
s
.52702 .31031 m
.55376 .319 L
s
.52745 .36702 m
.55333 .35601 L
s
.53128 .41908 m
.5495 .39767 L
s
.53391 .46771 m
.54687 .44276 L
s
.53547 .51527 m
.54531 .48893 L
s
.53645 .56245 m
.54433 .53546 L
s
.53711 .60949 m
.54366 .58215 L
s
.53759 .65646 m
.54319 .6289 L
s
.53795 .70338 m
.54283 .67569 L
s
.53823 .75029 m
.54255 .72251 L
s
.53845 .79718 m
.54233 .76934 L
s
.58434 .01974 m
.59016 .04725 L
s
.58382 .06672 m
.59068 .09399 L
s
.58308 .11379 m
.59141 .14064 L
s
.58198 .16104 m
.59252 .18711 L
s
.58019 .20878 m
.59431 .23309 L
s
.57717 .25799 m
.59732 .2776 L
s
.57353 .31159 m
.60097 .31772 L
s
.57481 .36807 m
.59969 .35496 L
s
.57858 .41944 m
.59592 .39731 L
s
.58103 .46784 m
.59347 .44263 L
s
.58249 .51532 m
.59201 .48887 L
s
.58341 .56248 m
.59108 .53543 L
s
.58405 .60951 m
.59045 .58213 L
s
.58451 .65647 m
.58999 .62889 L
s
.58485 .70339 m
.58965 .67569 L
s
.58512 .7503 m
.58938 .7225 L
s
.58534 .79719 m
.58916 .76933 L
s
.63116 .01975 m
.63706 .04724 L
s
.63062 .06673 m
.6376 .09397 L
s
.62986 .11381 m
.63836 .14061 L
s
.62871 .16109 m
.63951 .18705 L
s
.62683 .20891 m
.64139 .23296 L
s
.62368 .25837 m
.64454 .27722 L
s
.62021 .31252 m
.64801 .31679 L
s
.62204 .36872 m
.64618 .35431 L
s
.62573 .41966 m
.64249 .39709 L
s
.62806 .46793 m
.64016 .44255 L
s
.62945 .51536 m
.63877 .48883 L
s
.63034 .5625 m
.63788 .53541 L
s
.63096 .60952 m
.63726 .58212 L
s
.6314 .65647 m
.63682 .62888 L
s
.63174 .7034 m
.63648 .67568 L
s
.632 .7503 m
.63622 .7225 L
s
.63221 .79719 m
.63601 .76933 L
s
.67799 .01975 m
.68395 .04723 L
s
.67744 .06674 m
.6845 .09396 L
s
.67666 .11383 m
.68528 .14059 L
s
.67548 .16113 m
.68646 .18701 L
s
.67354 .209 m
.6884 .23287 L
s
.67029 .25866 m
.69165 .27693 L
s
.66699 .31318 m
.69495 .31613 L
s
.66915 .36913 m
.69279 .3539 L
s
.67278 .4198 m
.68916 .39695 L
s
.67503 .46798 m
.68691 .4425 L
s
.67638 .51538 m
.68556 .48881 L
s
.67725 .56251 m
.68469 .5354 L
s
.67785 .60953 m
.68409 .58211 L
s
.67829 .65648 m
.68365 .62888 L
s
.67862 .7034 m
.68332 .67568 L
s
.67888 .7503 m
.68306 .7225 L
s
.67909 .79719 m
.68285 .76933 L
s
.72483 .01976 m
.73083 .04723 L
s
.72427 .06675 m
.73139 .09395 L
s
.72348 .11385 m
.73218 .14058 L
s
.72227 .16116 m
.73339 .18699 L
s
.72029 .20907 m
.73537 .2328 L
s
.71697 .25886 m
.73869 .27672 L
s
.71381 .31364 m
.74185 .31567 L
s
.71619 .3694 m
.73947 .35363 L
s
.71976 .41989 m
.7359 .39686 L
s
.72196 .46801 m
.7337 .44246 L
s
.72329 .5154 m
.73237 .48879 L
s
.72414 .56252 m
.73152 .53539 L
s
.72473 .60953 m
.73093 .58211 L
s
.72516 .65648 m
.7305 .62888 L
s
.72549 .7034 m
.73017 .67568 L
s
.72575 .7503 m
.72991 .7225 L
s
.72595 .79719 m
.72971 .76933 L
s
.77167 .01976 m
.77771 .04722 L
s
.77111 .06676 m
.77827 .09395 L
s
.77031 .11385 m
.77907 .14057 L
s
.76909 .16118 m
.7803 .18697 L
s
.76707 .20912 m
.78231 .23275 L
s
.76371 .25901 m
.78567 .27658 L
s
.76065 .31396 m
.78873 .31535 L
s
.76318 .36958 m
.78621 .35345 L
s
.76671 .41995 m
.78267 .3968 L
s
.76887 .46804 m
.78051 .44244 L
s
.77018 .51541 m
.7792 .48878 L
s
.77102 .56253 m
.77836 .53539 L
s
.77161 .60953 m
.77777 .5821 L
s
.77204 .65648 m
.77735 .62887 L
s
.77236 .7034 m
.77702 .67568 L
s
.77262 .7503 m
.77677 .7225 L
s
.77282 .79719 m
.77656 .76933 L
s
.81852 .01976 m
.82458 .04722 L
s
.81796 .06676 m
.82514 .09394 L
s
.81715 .11386 m
.82595 .14056 L
s
.81591 .1612 m
.82719 .18695 L
s
.81388 .20916 m
.82923 .23271 L
s
.81049 .25912 m
.83261 .27647 L
s
.8075 .31417 m
.8356 .31514 L
s
.81012 .3697 m
.83298 .35333 L
s
.81363 .41999 m
.82947 .39676 L
s
.81577 .46805 m
.82733 .44242 L
s
.81706 .51542 m
.82604 .48878 L
s
.8179 .56253 m
.82521 .53538 L
s
.81848 .60954 m
.82462 .5821 L
s
.8189 .65649 m
.8242 .62887 L
s
.81923 .7034 m
.82388 .67567 L
s
.81948 .7503 m
.82362 .7225 L
s
.81969 .79719 m
.82342 .76933 L
s
.86538 .01977 m
.87145 .04722 L
s
.86481 .06676 m
.87201 .09394 L
s
.864 .11387 m
.87283 .14056 L
s
.86275 .16121 m
.87407 .18694 L
s
.8607 .20918 m
.87613 .23269 L
s
.85729 .25919 m
.87953 .2764 L
s
.85436 .31432 m
.88247 .31499 L
s
.85704 .36978 m
.87979 .35325 L
s
.86053 .42002 m
.8763 .39674 L
s
.86265 .46806 m
.87417 .44241 L
s
.86394 .51542 m
.87289 .48877 L
s
.86477 .56254 m
.87206 .53538 L
s
.86535 .60954 m
.87148 .5821 L
s
.86577 .65649 m
.87105 .62887 L
s
.86609 .7034 m
.87073 .67567 L
s
.86634 .75031 m
.87048 .72249 L
s
.86655 .79719 m
.87028 .76933 L
s
.91223 .01977 m
.91831 .04722 L
s
.91166 .06677 m
.91888 .09394 L
s
.91085 .11387 m
.9197 .14056 L
s
.9096 .16121 m
.92095 .18694 L
s
.90753 .2092 m
.92301 .23267 L
s
.90411 .25924 m
.92643 .27634 L
s
.90122 .31443 m
.92933 .31488 L
s
.90394 .36983 m
.92661 .3532 L
s
.90742 .42003 m
.92313 .39672 L
s
.90953 .46807 m
.92102 .44241 L
s
.91081 .51543 m
.91974 .48877 L
s
.91164 .56254 m
.91891 .53538 L
s
.91221 .60954 m
.91833 .5821 L
s
.91263 .65649 m
.91791 .62887 L
s
.91296 .70341 m
.91759 .67567 L
s
.91321 .75031 m
.91734 .72249 L
s
.91341 .79719 m
.91713 .76933 L
s
.95909 .01977 m
.96518 .04722 L
s
.95852 .06677 m
.96575 .09394 L
s
.9577 .11387 m
.96656 .14055 L
s
.95645 .16122 m
.96782 .18693 L
s
.95437 .20921 m
.96989 .23266 L
s
.95095 .25928 m
.97332 .27631 L
s
.94808 .3145 m
.97619 .31481 L
s
.95083 .36987 m
.97344 .35316 L
s
.95429 .42005 m
.96997 .39671 L
s
.9564 .46807 m
.96787 .4424 L
s
.95767 .51543 m
.96659 .48877 L
s
.9585 .56254 m
.96577 .53538 L
s
.95908 .60954 m
.96519 .5821 L
s
.9595 .65649 m
.96477 .62887 L
s
.95982 .70341 m
.96445 .67567 L
s
.96007 .75031 m
.9642 .72249 L
s
.96027 .79719 m
.96399 .76933 L
s
0 0 m
1 0 L
1 .81672 L
0 .81672 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.875, 230.25},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000iR000`400?l00000o`00003oL?ooool0
0ol0003oooooooooo`2Vooooo`00L?ooool00ol0003oooooooooo`2Vooooo`00L?ooool00ol0003o
ooooooooo`2Vooooo`00L?ooool00ol0003oooooooooo`2Vooooo`00L?ooool00ol0003ooooooooo
o`2Vooooo`00L?ooool00ol0003oooooooooo`2Vooooo`001_ooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo0_l0000;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`09ooooo`001_ooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo0_l0000;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`09ooooo`001_ooool00ol0003oooooooooo`0;ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo0_l0000;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`09ooooo`001_ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`08ooooo`001_ooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`Co000000?oooooo`000?ooool01oooool3o`0000[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Sooooo0007oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00Go0000ooooooooooooooooo`000008ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00Sooooo0007ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00Go0000ooooooooooooooooo`000008
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00Sooooo0007ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00Go0000oooo
ooooooooooooo`000008ooooo`;o00003?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00_ooooo00?o0000ooooooooool01oooool000Oooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`;o00003?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool01oooool0073ooooo00?o0000ooooooooool0Y_ooool0073ooooo
00?o0000ooooooooool0Y_ooool0073ooooo00?o0000ooooooooool0Y_ooool0073ooooo00?o0000
ooooooooool0Y_ooool000Kooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`;o00002oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02Oooool000Kooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`?o
00002_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool02Oooool000Kooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`;o0000
2oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2Oooool000Kooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00Sooooo0006ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`08ooooo`001oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02?ooool000Oooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00Sooooo0007ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02_ooool2o`0000cooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo00Oooooo0007ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool2o`0000cooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00Oooooo001`ooooo`03o`000?oooooooooo0:Kooooo001`oooo
o`03o`000?oooooooooo0:Kooooo001`ooooo`03o`000?oooooooooo0:Kooooo001`ooooo`;o0000
Yoooool000Kooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`;o00002ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool000Kooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`;o00002oooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
00Kooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`;o00002oooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool000Ko
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo0006ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`09ooooo`001oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02?ooool000Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00Sooooo0007ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02Oooool2o`0000cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00Sooooo0007ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool02Oooool2o`0000cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00Oooooo001`ooooo`;o0000Yoooool0073ooooo00?o0000ooooooooool0Y_oo
ool0073ooooo00?o0000ooooooooool0Y_ooool0073ooooo00?o0000ooooooooool0Y_ooool000Ko
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`;o00002oooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo01Oooooo0006ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02_ooool2o`0000_ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo0006ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool2o`0000_ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00[ooooo0006ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`09ooooo`001_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool000Oooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Sooooo0007ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`08ooooo`001ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Wooooo0_l0000<ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`08ooooo`001oooool4
o`0000Wooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00_ooooo0_l0000;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`09ooooo`;o00003?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00_ooooo00?o0000ooooooooool01oooool01?l0003oooooooooool0000<ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`08ooooo`Co00003?oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01ooo
ool4o`0000Wooooo0003ooooo`Co000000?oooooo`000?ooool0;_ooool4o`000003ooooool0003o
oooo037ooooo00?o0000ooooooooool0<?ooool00ol0003oooooooooo`0booooo`03o`000?oooooo
oooo03?ooooo00?o0000ooooooooool02?ooool000Wooooo00?o0000ooooooooool0<Oooool00ol0
003oooooooooo`0`ooooo`03o`000?oooooooooo033ooooo00?o0000ooooooooool0<oooool00ol0
003oooooooooo`0booooo`03o`000?oooooooooo00Sooooo0009ooooo`03o`000?oooooooooo037o
oooo00?o0000ooooooooool0<?ooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo03?o
oooo00?o0000ooooooooool0<_ooool00ol0003oooooooooo`08ooooo`001oooool3o`0003?ooooo
00?o0000ooooooooool0<?ooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo037ooooo
0ol0000booooo`?o00002_ooool000Kooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool06Oooool00ol0003ooooooooo
o`2Vooooo`001_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooool000002_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02oooool000Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooo000000[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00_ooooo0006ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool2o`0000_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo003oo`0001[o00000007ooooo`03o`000?oooooooooo00Oooooo00Co
0000oooooooooooo00001oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool01_ooool00ol0003oooooo`000009ooooo`;o00002Oooool01?l0003ooooo
ooooool00006ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooo000000[ooooo00?o0000ooooooooool01oooool01?l0003o
ooooooooool00007ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`05ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool02?ooool0
1?l0003oooooooooool00006ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool0
2?ooool00ol0003oooooo`000007ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo000000[ooooo00?o0000ooooooooool0
1oooool1o`0000001oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`09ooooo`;o00003?ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`09ooooo`;o00003Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02Oooool2o`0000cooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02?ooool000Oooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Oooooo0007oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool2o`0000gooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Kooooo001`ooooo`03
o`000?oooooooooo0:Kooooo001`ooooo`03o`000?oooooooooo0:Kooooo001`ooooo`03o`000?oo
oooooooo0:Kooooo001`ooooo`03o`000?oooooooooo0:Kooooo0006ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`1<ooooo`03o`000?oooooooooo
0:Kooooo0006ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooo`00000:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0S_ooool000Kooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`04o`000?oooooo0000o`0000Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool2o`0000_ooooo0_l0000;ooooo`;o00002oooool2o`0000_o
oooo0_l0000;ooooo`;o00002oooool2o`0000cooooo0_l0000<ooooo`001_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo0_l0000;ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`09ooooo`001_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo0_l0000;ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo0_l0
000<ooooo`03o`000?oooooooooo00Sooooo0007ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Wooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`07ooooo`001oooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo0_l0000<ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`06ooooo`001oooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo0_l0000<ooooo`03o`000?oooooooooo00cooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`05ooooo`001oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooool000003?ooool00ol0003oooooooooo`2Gooooo`00L?oo
ool00ol0003oooooooooo`2Vooooo`00L?ooool00ol0003oooooooooo`2Vooooo`00L?ooool00ol0
003oooooooooo`2Vooooo`00L?ooool2o`000:Oooooo001`ooooo`03o`000?oooooooooo0:Kooooo
0006ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool03Oooool00ol0003ooooooooo
o`2Vooooo`001_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[ooooo0_l00000
0ooooooo0000ooooo`08ooooo`;o0000WOooool000Kooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`0;ooooo`;o00002oooool00ol0003oooooooooo`08ooooo`;o00002oooool2o`00
08?ooooo0006ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo0ol0000:ooooo`?o00002?ooool5o`0000So
oooo1Ol00008ooooo`Go00002?ooool5o`0000Sooooo1Ol00008ooooo`Go00002?ooool5o`0002Go
oooo0006ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool2o`0000cooooo
00?o0000ooooooooool02oooool2o`0000_ooooo0_l0000;ooooo`?o00002_ooool3o`0000[ooooo
1?l00009ooooo`Co00002Oooool4o`0000Wooooo1?l00009ooooo`Co00001Oooool8o`0000Gooooo
2Ol00006ooooo`001oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooool000003?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool0Noooool000Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`09
ooooo`04o`000?ooooooooooo`0000cooooo00?o0000ooooooooool0U_ooool000Oooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo0:Kooooo0007oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0FOooool00ol0003oooooooooo`2Voooo
o`00L?ooool2o`000:Oooooo001`ooooo`03o`000?oooooooooo0:Kooooo001`ooooo`03o`000?oo
oooooooo0:Kooooo001`ooooo`03o`000?oooooooooo0:Kooooo0006ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo
0:Kooooo0006ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`09ooooo`03o`000?oooooooooo00Wooooo0_l0000?ooooo`03o`000?oooooooooo06So
oooo0_l0000;ooooo`;o00003?ooool2o`0000_ooooo0_l0000;ooooo`;o00001oooool000Kooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo02Oooooo
0_l0000;ooooo`;o00002oooool2o`0000_ooooo0_l0000;ooooo`;o00002_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00Oooooo0006ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00_ooooo0_l0
0008ooooo`?o000000?oooooo`000?ooool02oooool5o`0000[ooooo0ol00008ooooo`?o00002ooo
ool2o`0000_ooooo0_l0000;ooooo`;o00003?ooool00ol0003oooooooooo`09ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool2o`0000_ooooo0_l0000;ooooo`;o00002_oo
ool000Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`08ooooo`Co00001_ooool4
o`0000_ooooo1?l00009ooooo`;o00003Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02_ooool2o`0000_ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`001oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool00_l0000Aooooo`;o00003?ooool00ol0003oooooooooo`0;oooo
o`;o00002oooool2o`0000_ooooo0_l0000<ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0;ooooo`001oooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0<ooooo`03
o`000?oooooooooo00Oooooo0_l0000_ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0<ooooo`001oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00_ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Eooooo`03o`00
0?oooooooooo0:Kooooo0007ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0<Ooo
ool00ol0003oooooooooo`2Vooooo`00L?ooool00ol0003oooooooooo`2Vooooo`00L?ooool00ol0
003oooooooooo`2Vooooo`00L?ooool00ol0003oooooooooo`2Vooooo`00L?ooool00ol0003ooooo
ooooo`2Vooooo`001_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo03?ooooo00?o
0000ooooooooool0Y_ooool000Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool03?ooool2o`0000cooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`06ooooo`001_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Oooool2o`0001cooooo00Co0000oooo
ool0003o00002_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool01_ooool000Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00[ooooo0_l0000Aooooo`03o`000?oooooooooo00Kooooo0_l0000;oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`07oooo
o`001_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`06ooooo`Wo00001oooool4o`0000Wooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Sooooo0007ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0<ooooo`;o0000
3_ooool00ol0003oooooooooo`03ooooo`;o000000?oooooo`000?ooool02Oooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool000Oooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00gooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool00000
2Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool000Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo01[ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Dooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02oooool000Oooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0aooooo`03o`000?oooooooooo0:Kooooo001`ooooo`03o`000?oooooooooo
0:Kooooo001`ooooo`03o`000?oooooooooo0:Kooooo001`ooooo`03o`000?oooooooooo0:Kooooo
001`ooooo`03o`000?oooooooooo0:Kooooo0006ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool0<oooool00ol0003oooooooooo`0cooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`07ooooo`001_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo03?ooooo0ol0000<ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`07ooooo`001_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo00Oooooo0_l0000Nooooo`;o00002Oooool00ol0003oooooo`00000<ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`08ooooo`00
1_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
6_ooool00ol0003oooooooooo`09ooooo`;o00003?ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02?ooool000Kooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo1?l00008ooooo`;o00003?oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`08ooooo`001oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool01_ooool4o`0000_ooooo00?o0000ooooooooool02oooool2
o`0000cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00Wooooo0007ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`0Cooooo`03o`000?oooooooooo00_ooooo00?o0000ooooool000002oooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool000Oo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01oo
oooo00Co0000oooooooooooo00002_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02Oooool000Oooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`0`ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0073ooooo
00?o0000ooooooooool0Y_ooool0073ooooo00?o0000ooooooooool0Y_ooool0073ooooo00?o0000
ooooooooool0Y_ooool0073ooooo0_l0002Wooooo`001_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`10ooooo`03
o`000?oooooooooo02Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool01oooool000Kooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo00Sooooo00?o0000ooooool00000
3?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
1oooool000Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Looooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02?ooool00ol0003oooooo`00000<ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`08ooooo`001_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`09ooooo`;o00003?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02?ooool000Kooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`06ooooo`Wo00002Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo0_l0000<ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`08ooooo`001oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo0007ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool05Oooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo00[ooooo0_l0000;ooooo`03o`000?oooooooooo00_ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`001oooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`0;ooooo`;o00002oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02Oooool000Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0??ooool00ol0003oooooo`00000:
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`00L?ooool2o`000:Oooooo001`ooooo`03o`000?oooooooooo0:Kooooo001`ooooo`03o`00
0?oooooooooo0:Kooooo001`ooooo`03o`000?oooooooooo0:Kooooo0006ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`1=ooooo`03o`000?oooooo
oooo0:Kooooo0006ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`09ooooo`;o00003?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool01oooool000Kooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02?ooool2o`00017o
oooo0_l0000;ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Oooool2o`0000co
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Oo
oooo0006ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool03Oooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`07ooooo`001_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo0_l0
000<ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`08ooooo`001oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo0_l0000<
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`08
ooooo`001oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo0_l0000<oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`08oooo
o`001oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool03?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo0ol0000:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`00
1oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooo`00000;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`09ooooo`00L?ooool00ol0003oooooooooo`2Vooooo`00L?ooool0
0ol0003oooooooooo`2Vooooo`00L?ooool00ol0003oooooooooo`2Vooooo`00L?ooool00ol0003o
ooooooooo`2Vooooo`00L?ooool00ol0003oooooooooo`2Vooooo`001_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0Looooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`09ooooo`;o00003?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool01oooool000Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool2o`0000cooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Oooooo0006oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo01[ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:oooo
o`04o`000?ooooooooooooooo`?o00001_ooool2o`0000cooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Oooooo0006ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
00_ooooo1Ol00009ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool01Ol0
003ooooooooooooooooo000000Sooooo0ol0000:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`08ooooo`001oooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`06oooo
o`Co00003Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Sooooo0007ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo01Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`08ooooo`00
1oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
2_ooool01?l0003oooooooooooooool3o`0000Kooooo0_l0000;ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`001oooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0Cooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0;ooooo`;o00002oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02Oooool0073ooooo00?o0000ooooooooool0Y_ooool0073ooooo00?o0000
ooooooooool0Y_ooool0073ooooo00?o0000ooooooooool0Y_ooool0073ooooo00?o0000oooooooo
ool0Y_ooool0073ooooo00?o0000ooooooooool0Y_ooool000Kooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo0_l0000<ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`08ooooo`001_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`0>ooooo`;o00002oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02Oooool2o`0000cooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Sooooo0006ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
00gooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool02Oooool2o`0000cooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00Sooooo0006ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`08ooooo`001_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02?ooool000Oooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo0007
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool2o`0000_ooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo0007oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo01Cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo00[ooooo0_l0000;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`09ooooo`001oooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo05Wooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00Wooooo001`ooooo`03o`000?oooooooooo0:Kooooo001`ooooo`03o`000?oo
oooooooo0:Kooooo001`ooooo`03o`000?oooooooooo0:Kooooo001`ooooo`;o0000Yoooool000Ko
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo02Oo
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Wo
oooo0_l0000<ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`08ooooo`001_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool06_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`09ooooo`;o00003?ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02?ooool000Kooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Sooooo0_l0
000@ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00Wooooo0_l0000<ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`08ooooo`001_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02Oooool2o`0000gooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`08ooooo`001_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02?ooool000Oooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00cooooo0_l00009ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool000Oooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo0007ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Dooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo0_l0000;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`09ooooo`001oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00_ooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02_ooool2o`0000_ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo001`ooooo`;o0000Yoooool0073o
oooo00?o0000ooooooooool0Y_ooool0073ooooo00?o0000ooooooooool0Y_ooool0073ooooo00?o
0000ooooooooool0Y_ooool000Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`08
ooooo`001_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool06_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Sooooo0006ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Iooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02?ooool000Kooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00cooooo0ol00009ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02?ooool000Kooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Sooooo1?l0000<ooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02?ooool000Oooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Kooooo0_l0000?ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00[ooooo0_l0000<ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`09ooooo`001oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`;o00003?ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool000Oo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01Ko
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool3o`0000[ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo0007ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo
0_l0000;ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`09ooooo`00L?ooool00ol0003oooooooooo`2Vooooo`00L?ooool00ol0003oooooooooo`2V
ooooo`00L?ooool00ol0003oooooooooo`2Vooooo`00L?ooool00ol0003oooooooooo`2Vooooo`00
1_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`08ooooo`001_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02?ooool000Kooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Sooooo0006ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool00ol00007ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Sooooo0006ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`?o
00002_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02?ooool000Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo00Cooooo0_l0000<ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`09ooooo`001oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool01?ooool2o`0000cooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo0007ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo
oooo00[ooooo00Co0000oooooooooooooooo0ol00006ooooo`;o00002oooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool000Oooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01Cooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool2o`0000_ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00Wooooo001`ooooo`03o`000?oooooooooo0:Kooooo001`ooooo`03
o`000?oooooooooo0:Kooooo001`ooooo`03o`000?oooooooooo0:Kooooo001`ooooo`03o`000?oo
oooooooo0:Kooooo001`ooooo`03o`000?oooooooooo0:Kooooo0000\
\>"],
  ImageRangeCache->{{{0, 280.875}, {229.25, 0}} -> {-2.13469, -1.1787, \
0.0190065, 0.0190065}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[field, Frame \[Rule] True];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81672 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.399807 0.187442 0.220934 0.187442 [
[.02492 -0.0125 -6.75 -10 ]
[.02492 -0.0125 6.75 0 ]
[.21237 -0.0125 -6.75 -10 ]
[.21237 -0.0125 6.75 0 ]
[.39981 -0.0125 -4 -10 ]
[.39981 -0.0125 4 0 ]
[.58725 -0.0125 -4 -10 ]
[.58725 -0.0125 4 0 ]
[.77469 -0.0125 -4 -10 ]
[.77469 -0.0125 4 0 ]
[.96213 -0.0125 -4 -10 ]
[.96213 -0.0125 4 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .03349 -13.5 -5 ]
[-0.0125 .03349 0 5 ]
[-0.0125 .22093 -8 -5 ]
[-0.0125 .22093 0 5 ]
[-0.0125 .40838 -8 -5 ]
[-0.0125 .40838 0 5 ]
[-0.0125 .59582 -8 -5 ]
[-0.0125 .59582 0 5 ]
[-0.0125 .78326 -8 -5 ]
[-0.0125 .78326 0 5 ]
[ 0 0 -0.125 0 ]
[ 0 .81672 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .81672 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02492 0 m
.02492 .00625 L
s
gsave
.02492 -0.0125 -67.75 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.500 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.21237 0 m
.21237 .00625 L
s
gsave
.21237 -0.0125 -67.75 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.500 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.39981 0 m
.39981 .00625 L
s
gsave
.39981 -0.0125 -65 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
1.000 setlinewidth
grestore
.58725 0 m
.58725 .00625 L
s
gsave
.58725 -0.0125 -65 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.77469 0 m
.77469 .00625 L
s
gsave
.77469 -0.0125 -65 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.96213 0 m
.96213 .00625 L
s
gsave
.96213 -0.0125 -65 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.125 Mabswid
.06241 0 m
.06241 .00375 L
s
.0999 0 m
.0999 .00375 L
s
.13739 0 m
.13739 .00375 L
s
.17488 0 m
.17488 .00375 L
s
.24985 0 m
.24985 .00375 L
s
.28734 0 m
.28734 .00375 L
s
.32483 0 m
.32483 .00375 L
s
.36232 0 m
.36232 .00375 L
s
.4373 0 m
.4373 .00375 L
s
.47478 0 m
.47478 .00375 L
s
.51227 0 m
.51227 .00375 L
s
.54976 0 m
.54976 .00375 L
s
.62474 0 m
.62474 .00375 L
s
.66223 0 m
.66223 .00375 L
s
.69971 0 m
.69971 .00375 L
s
.7372 0 m
.7372 .00375 L
s
.81218 0 m
.81218 .00375 L
s
.84967 0 m
.84967 .00375 L
s
.88716 0 m
.88716 .00375 L
s
.92464 0 m
.92464 .00375 L
s
.99962 0 m
.99962 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .03349 m
.00625 .03349 L
s
gsave
-0.0125 .03349 -74.5 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.500 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
0 .22093 m
.00625 .22093 L
s
gsave
-0.0125 .22093 -69 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
1.000 setlinewidth
grestore
0 .40838 m
.00625 .40838 L
s
gsave
-0.0125 .40838 -69 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
0 .59582 m
.00625 .59582 L
s
gsave
-0.0125 .59582 -69 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
0 .78326 m
.00625 .78326 L
s
gsave
-0.0125 .78326 -69 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.125 Mabswid
0 .07098 m
.00375 .07098 L
s
0 .10847 m
.00375 .10847 L
s
0 .14596 m
.00375 .14596 L
s
0 .18345 m
.00375 .18345 L
s
0 .25842 m
.00375 .25842 L
s
0 .29591 m
.00375 .29591 L
s
0 .3334 m
.00375 .3334 L
s
0 .37089 m
.00375 .37089 L
s
0 .44586 m
.00375 .44586 L
s
0 .48335 m
.00375 .48335 L
s
0 .52084 m
.00375 .52084 L
s
0 .55833 m
.00375 .55833 L
s
0 .63331 m
.00375 .63331 L
s
0 .6708 m
.00375 .6708 L
s
0 .70828 m
.00375 .70828 L
s
0 .74577 m
.00375 .74577 L
s
.25 Mabswid
0 0 m
0 .81672 L
s
.02492 .81047 m
.02492 .81672 L
s
.21237 .81047 m
.21237 .81672 L
s
.39981 .81047 m
.39981 .81672 L
s
.58725 .81047 m
.58725 .81672 L
s
.77469 .81047 m
.77469 .81672 L
s
.96213 .81047 m
.96213 .81672 L
s
.125 Mabswid
.06241 .81297 m
.06241 .81672 L
s
.0999 .81297 m
.0999 .81672 L
s
.13739 .81297 m
.13739 .81672 L
s
.17488 .81297 m
.17488 .81672 L
s
.24985 .81297 m
.24985 .81672 L
s
.28734 .81297 m
.28734 .81672 L
s
.32483 .81297 m
.32483 .81672 L
s
.36232 .81297 m
.36232 .81672 L
s
.4373 .81297 m
.4373 .81672 L
s
.47478 .81297 m
.47478 .81672 L
s
.51227 .81297 m
.51227 .81672 L
s
.54976 .81297 m
.54976 .81672 L
s
.62474 .81297 m
.62474 .81672 L
s
.66223 .81297 m
.66223 .81672 L
s
.69971 .81297 m
.69971 .81672 L
s
.7372 .81297 m
.7372 .81672 L
s
.81218 .81297 m
.81218 .81672 L
s
.84967 .81297 m
.84967 .81672 L
s
.88716 .81297 m
.88716 .81672 L
s
.92464 .81297 m
.92464 .81672 L
s
.99962 .81297 m
.99962 .81672 L
s
.25 Mabswid
0 .81672 m
1 .81672 L
s
.99375 .03349 m
1 .03349 L
s
.99375 .22093 m
1 .22093 L
s
.99375 .40838 m
1 .40838 L
s
.99375 .59582 m
1 .59582 L
s
.99375 .78326 m
1 .78326 L
s
.125 Mabswid
.99625 .07098 m
1 .07098 L
s
.99625 .10847 m
1 .10847 L
s
.99625 .14596 m
1 .14596 L
s
.99625 .18345 m
1 .18345 L
s
.99625 .25842 m
1 .25842 L
s
.99625 .29591 m
1 .29591 L
s
.99625 .3334 m
1 .3334 L
s
.99625 .37089 m
1 .37089 L
s
.99625 .44586 m
1 .44586 L
s
.99625 .48335 m
1 .48335 L
s
.99625 .52084 m
1 .52084 L
s
.99625 .55833 m
1 .55833 L
s
.99625 .63331 m
1 .63331 L
s
.99625 .6708 m
1 .6708 L
s
.99625 .70828 m
1 .70828 L
s
.99625 .74577 m
1 .74577 L
s
.25 Mabswid
1 0 m
1 .81672 L
s
0 .22093 m
1 .22093 L
s
.39981 0 m
.39981 .81672 L
s
.0005 w
.02435 .01945 m
.02549 .04754 L
s
.02433 .06631 m
.02551 .0944 L
s
.02431 .11317 m
.02553 .14126 L
s
.02429 .16003 m
.02555 .18812 L
s
.02427 .20689 m
.02557 .23498 L
s
.02425 .25375 m
.0256 .28184 L
s
.02422 .30061 m
.02562 .3287 L
s
.0242 .34748 m
.02565 .37556 L
s
.02417 .39434 m
.02568 .42241 L
s
.02414 .4412 m
.02571 .46927 L
s
.0241 .48806 m
.02574 .51613 L
s
.02406 .53493 m
.02578 .56299 L
s
.02402 .58179 m
.02582 .60985 L
s
.02398 .62865 m
.02587 .65671 L
s
.02393 .67552 m
.02592 .70356 L
s
.02387 .72238 m
.02597 .75042 L
s
.02381 .76925 m
.02604 .79727 L
s
.07102 .01946 m
.07255 .04753 L
s
.07098 .06632 m
.07258 .09439 L
s
.07095 .11318 m
.07262 .14125 L
s
.07091 .16004 m
.07266 .1881 L
s
.07087 .20691 m
.0727 .23496 L
s
.07082 .25377 m
.07275 .28182 L
s
.07077 .30063 m
.0728 .32868 L
s
.07071 .3475 m
.07286 .37553 L
s
.07064 .39436 m
.07292 .42239 L
s
.07057 .44123 m
.073 .46924 L
s
.07049 .4881 m
.07308 .5161 L
s
.07039 .53497 m
.07317 .56295 L
s
.07028 .58184 m
.07329 .6098 L
s
.07015 .62872 m
.07342 .65664 L
s
.07 .6756 m
.07357 .70348 L
s
.06981 .72248 m
.07376 .75032 L
s
.06958 .76938 m
.07399 .79714 L
s
.11764 .01947 m
.11965 .04751 L
s
.11759 .06633 m
.1197 .09437 L
s
.11752 .1132 m
.11977 .14123 L
s
.11745 .16007 m
.11984 .18808 L
s
.11737 .20693 m
.11992 .23493 L
s
.11728 .2538 m
.12001 .28179 L
s
.11717 .30067 m
.12012 .32864 L
s
.11705 .34755 m
.12024 .37548 L
s
.1169 .39443 m
.12039 .42233 L
s
.11672 .44131 m
.12057 .46916 L
s
.1165 .4882 m
.12079 .51599 L
s
.11623 .53511 m
.12106 .56281 L
s
.11588 .58203 m
.12141 .6096 L
s
.11542 .629 m
.12187 .65636 L
s
.11477 .67603 m
.12252 .70305 L
s
.11382 .7232 m
.12347 .7496 L
s
.11233 .7707 m
.12496 .79582 L
s
.16423 .01949 m
.16677 .04749 L
s
.16414 .06636 m
.16687 .09434 L
s
.16404 .11323 m
.16697 .14119 L
s
.16391 .16011 m
.1671 .18804 L
s
.16377 .20698 m
.16724 .23488 L
s
.16359 .25387 m
.16742 .28172 L
s
.16337 .30076 m
.16764 .32855 L
s
.1631 .34766 m
.1679 .37537 L
s
.16276 .39459 m
.16825 .42216 L
s
.1623 .44155 m
.16871 .46892 L
s
.16166 .48857 m
.16935 .51562 L
s
.16073 .53573 m
.17028 .56218 L
s
.15927 .58322 m
.17174 .60842 L
s
.15681 .63163 m
.1742 .65373 L
s
.15304 .68305 m
.17797 .69603 L
s
.1518 .73954 m
.17921 .73326 L
s
.15546 .7931 m
.17555 .77342 L
s
.21081 .01952 m
.21392 .04746 L
s
.21067 .0664 m
.21406 .09431 L
s
.2105 .11328 m
.21423 .14115 L
s
.2103 .16017 m
.21443 .18798 L
s
.21005 .20707 m
.21468 .2348 L
s
.20973 .25399 m
.215 .2816 L
s
.2093 .30093 m
.21543 .32838 L
s
.20873 .34794 m
.216 .37509 L
s
.20789 .39505 m
.21684 .4217 L
s
.20662 .44241 m
.21811 .46807 L
s
.2045 .49044 m
.22023 .51375 L
s
.20102 .54066 m
.22371 .55726 L
s
.19831 .59608 m
.22642 .59556 L
s
.20122 .65124 m
.22351 .63411 L
s
.20463 .70128 m
.2201 .6778 L
s
.20669 .74926 m
.21804 .72354 L
s
.20794 .79661 m
.21679 .76992 L
s
.25739 .01955 m
.26106 .04743 L
s
.25719 .06644 m
.26126 .09426 L
s
.25694 .11334 m
.26151 .14109 L
s
.25663 .16026 m
.26182 .18789 L
s
.25623 .2072 m
.26222 .23467 L
s
.25567 .25419 m
.26278 .2814 L
s
.25488 .30128 m
.26357 .32803 L
s
.25368 .3486 m
.26477 .37443 L
s
.25171 .3965 m
.26674 .42026 L
s
.24841 .44626 m
.27004 .46422 L
s
.24521 .50097 m
.27324 .50322 L
s
.24755 .55678 m
.27091 .54113 L
s
.25113 .60731 m
.26732 .58432 L
s
.25334 .65545 m
.26511 .62991 L
s
.25467 .70284 m
.26378 .67624 L
s
.25553 .74996 m
.26292 .72284 L
s
.25612 .79697 m
.26233 .76955 L
s
.30399 .01959 m
.30819 .04739 L
s
.30372 .06649 m
.30845 .09421 L
s
.30339 .11342 m
.30878 .14101 L
s
.30295 .16037 m
.30922 .18778 L
s
.30234 .20738 m
.30983 .23448 L
s
.30146 .25452 m
.31072 .28107 L
s
.30008 .30194 m
.31209 .32737 L
s
.29779 .35017 m
.31439 .37286 L
s
.29412 .40099 m
.31805 .41576 L
s
.29215 .45709 m
.32002 .45338 L
s
.29555 .5114 m
.31662 .49279 L
s
.29874 .56095 m
.31343 .53697 L
s
.30065 .60878 m
.31153 .58286 L
s
.30181 .65607 m
.31036 .62929 L
s
.30258 .70315 m
.30959 .67593 L
s
.30312 .75014 m
.30905 .72266 L
s
.30352 .79708 m
.30865 .76944 L
s
.35062 .01963 m
.35527 .04736 L
s
.35029 .06655 m
.3556 .09416 L
s
.34987 .1135 m
.35603 .14093 L
s
.34928 .1605 m
.35661 .18765 L
s
.34844 .20762 m
.35745 .23425 L
s
.34714 .25499 m
.35875 .2806 L
s
.34498 .30307 m
.36091 .32624 L
s
.34146 .35342 m
.36444 .36962 L
s
.3389 .40901 m
.36699 .40774 L
s
.34194 .46399 m
.36395 .44649 L
s
.34531 .5139 m
.36059 .4903 L
s
.34733 .56185 m
.35856 .53607 L
s
.34856 .60917 m
.35733 .58246 L
s
.34936 .65627 m
.35653 .62908 L
s
.34993 .70327 m
.35597 .67581 L
s
.35034 .75021 m
.35556 .72259 L
s
.35065 .79713 m
.35524 .76939 L
s
.39729 .01966 m
.40232 .04732 L
s
.39691 .0666 m
.4027 .09411 L
s
.3964 .11357 m
.40322 .14085 L
s
.39567 .16064 m
.40394 .18751 L
s
.39459 .20788 m
.40503 .23399 L
s
.39283 .25559 m
.40678 .28 L
s
.38987 .30471 m
.40975 .3246 L
s
.38617 .35811 m
.41345 .36493 L
s
.38723 .41466 m
.41238 .40209 L
s
.39103 .46621 m
.40859 .44426 L
s
.39352 .51467 m
.40609 .48952 L
s
.395 .56217 m
.40461 .53575 L
s
.39595 .60934 m
.40367 .5823 L
s
.39659 .65636 m
.40303 .62899 L
s
.39705 .70332 m
.40256 .67575 L
s
.3974 .75025 m
.40222 .72255 L
s
.39767 .79716 m
.40194 .76937 L
s
.44401 .01969 m
.44933 .0473 L
s
.44358 .06664 m
.44976 .09407 L
s
.44299 .11365 m
.45035 .14078 L
s
.44214 .16077 m
.4512 .18738 L
s
.44082 .20815 m
.45251 .23372 L
s
.43864 .25625 m
.4547 .27933 L
s
.43508 .30669 m
.45825 .32262 L
s
.43264 .3624 m
.4607 .36064 L
s
.43576 .41724 m
.45758 .39951 L
s
.43909 .46708 m
.45424 .4434 L
s
.44109 .515 m
.45225 .48919 L
s
.4423 .56232 m
.45103 .53559 L
s
.4431 .60942 m
.45023 .58222 L
s
.44366 .65641 m
.44968 .62895 L
s
.44407 .70335 m
.44927 .67572 L
s
.44438 .75027 m
.44896 .72253 L
s
.44463 .79717 m
.44871 .76935 L
s
.49076 .01971 m
.4963 .04727 L
s
.49029 .06667 m
.49677 .09403 L
s
.48964 .1137 m
.49742 .14072 L
s
.48868 .16088 m
.49838 .18727 L
s
.48717 .2084 m
.49989 .23347 L
s
.48463 .25691 m
.50243 .27868 L
s
.48082 .30865 m
.50624 .32066 L
s
.47998 .36528 m
.50707 .35776 L
s
.48372 .41845 m
.50333 .3983 L
s
.48664 .46749 m
.50042 .44298 L
s
.48836 .51517 m
.4987 .48903 L
s
.48943 .5624 m
.49763 .53551 L
s
.49014 .60946 m
.49692 .58217 L
s
.49065 .65644 m
.49641 .62892 L
s
.49103 .70337 m
.49603 .67571 L
s
.49132 .75028 m
.49574 .72252 L
s
.49155 .79718 m
.49551 .76934 L
s
.53754 .01973 m
.54324 .04726 L
s
.53704 .0667 m
.54374 .09401 L
s
.53634 .11375 m
.54444 .14068 L
s
.5353 .16097 m
.54548 .18718 L
s
.53363 .20861 m
.54715 .23326 L
s
.53081 .2575 m
.54997 .27809 L
s
.52702 .31031 m
.55376 .319 L
s
.52745 .36702 m
.55333 .35601 L
s
.53128 .41908 m
.5495 .39767 L
s
.53391 .46771 m
.54687 .44276 L
s
.53547 .51527 m
.54531 .48893 L
s
.53645 .56245 m
.54433 .53546 L
s
.53711 .60949 m
.54366 .58215 L
s
.53759 .65646 m
.54319 .6289 L
s
.53795 .70338 m
.54283 .67569 L
s
.53823 .75029 m
.54255 .72251 L
s
.53845 .79718 m
.54233 .76934 L
s
.58434 .01974 m
.59016 .04725 L
s
.58382 .06672 m
.59068 .09399 L
s
.58308 .11379 m
.59141 .14064 L
s
.58198 .16104 m
.59252 .18711 L
s
.58019 .20878 m
.59431 .23309 L
s
.57717 .25799 m
.59732 .2776 L
s
.57353 .31159 m
.60097 .31772 L
s
.57481 .36807 m
.59969 .35496 L
s
.57858 .41944 m
.59592 .39731 L
s
.58103 .46784 m
.59347 .44263 L
s
.58249 .51532 m
.59201 .48887 L
s
.58341 .56248 m
.59108 .53543 L
s
.58405 .60951 m
.59045 .58213 L
s
.58451 .65647 m
.58999 .62889 L
s
.58485 .70339 m
.58965 .67569 L
s
.58512 .7503 m
.58938 .7225 L
s
.58534 .79719 m
.58916 .76933 L
s
.63116 .01975 m
.63706 .04724 L
s
.63062 .06673 m
.6376 .09397 L
s
.62986 .11381 m
.63836 .14061 L
s
.62871 .16109 m
.63951 .18705 L
s
.62683 .20891 m
.64139 .23296 L
s
.62368 .25837 m
.64454 .27722 L
s
.62021 .31252 m
.64801 .31679 L
s
.62204 .36872 m
.64618 .35431 L
s
.62573 .41966 m
.64249 .39709 L
s
.62806 .46793 m
.64016 .44255 L
s
.62945 .51536 m
.63877 .48883 L
s
.63034 .5625 m
.63788 .53541 L
s
.63096 .60952 m
.63726 .58212 L
s
.6314 .65647 m
.63682 .62888 L
s
.63174 .7034 m
.63648 .67568 L
s
.632 .7503 m
.63622 .7225 L
s
.63221 .79719 m
.63601 .76933 L
s
.67799 .01975 m
.68395 .04723 L
s
.67744 .06674 m
.6845 .09396 L
s
.67666 .11383 m
.68528 .14059 L
s
.67548 .16113 m
.68646 .18701 L
s
.67354 .209 m
.6884 .23287 L
s
.67029 .25866 m
.69165 .27693 L
s
.66699 .31318 m
.69495 .31613 L
s
.66915 .36913 m
.69279 .3539 L
s
.67278 .4198 m
.68916 .39695 L
s
.67503 .46798 m
.68691 .4425 L
s
.67638 .51538 m
.68556 .48881 L
s
.67725 .56251 m
.68469 .5354 L
s
.67785 .60953 m
.68409 .58211 L
s
.67829 .65648 m
.68365 .62888 L
s
.67862 .7034 m
.68332 .67568 L
s
.67888 .7503 m
.68306 .7225 L
s
.67909 .79719 m
.68285 .76933 L
s
.72483 .01976 m
.73083 .04723 L
s
.72427 .06675 m
.73139 .09395 L
s
.72348 .11385 m
.73218 .14058 L
s
.72227 .16116 m
.73339 .18699 L
s
.72029 .20907 m
.73537 .2328 L
s
.71697 .25886 m
.73869 .27672 L
s
.71381 .31364 m
.74185 .31567 L
s
.71619 .3694 m
.73947 .35363 L
s
.71976 .41989 m
.7359 .39686 L
s
.72196 .46801 m
.7337 .44246 L
s
.72329 .5154 m
.73237 .48879 L
s
.72414 .56252 m
.73152 .53539 L
s
.72473 .60953 m
.73093 .58211 L
s
.72516 .65648 m
.7305 .62888 L
s
.72549 .7034 m
.73017 .67568 L
s
.72575 .7503 m
.72991 .7225 L
s
.72595 .79719 m
.72971 .76933 L
s
.77167 .01976 m
.77771 .04722 L
s
.77111 .06676 m
.77827 .09395 L
s
.77031 .11385 m
.77907 .14057 L
s
.76909 .16118 m
.7803 .18697 L
s
.76707 .20912 m
.78231 .23275 L
s
.76371 .25901 m
.78567 .27658 L
s
.76065 .31396 m
.78873 .31535 L
s
.76318 .36958 m
.78621 .35345 L
s
.76671 .41995 m
.78267 .3968 L
s
.76887 .46804 m
.78051 .44244 L
s
.77018 .51541 m
.7792 .48878 L
s
.77102 .56253 m
.77836 .53539 L
s
.77161 .60953 m
.77777 .5821 L
s
.77204 .65648 m
.77735 .62887 L
s
.77236 .7034 m
.77702 .67568 L
s
.77262 .7503 m
.77677 .7225 L
s
.77282 .79719 m
.77656 .76933 L
s
.81852 .01976 m
.82458 .04722 L
s
.81796 .06676 m
.82514 .09394 L
s
.81715 .11386 m
.82595 .14056 L
s
.81591 .1612 m
.82719 .18695 L
s
.81388 .20916 m
.82923 .23271 L
s
.81049 .25912 m
.83261 .27647 L
s
.8075 .31417 m
.8356 .31514 L
s
.81012 .3697 m
.83298 .35333 L
s
.81363 .41999 m
.82947 .39676 L
s
.81577 .46805 m
.82733 .44242 L
s
.81706 .51542 m
.82604 .48878 L
s
.8179 .56253 m
.82521 .53538 L
s
.81848 .60954 m
.82462 .5821 L
s
.8189 .65649 m
.8242 .62887 L
s
.81923 .7034 m
.82388 .67567 L
s
.81948 .7503 m
.82362 .7225 L
s
.81969 .79719 m
.82342 .76933 L
s
.86538 .01977 m
.87145 .04722 L
s
.86481 .06676 m
.87201 .09394 L
s
.864 .11387 m
.87283 .14056 L
s
.86275 .16121 m
.87407 .18694 L
s
.8607 .20918 m
.87613 .23269 L
s
.85729 .25919 m
.87953 .2764 L
s
.85436 .31432 m
.88247 .31499 L
s
.85704 .36978 m
.87979 .35325 L
s
.86053 .42002 m
.8763 .39674 L
s
.86265 .46806 m
.87417 .44241 L
s
.86394 .51542 m
.87289 .48877 L
s
.86477 .56254 m
.87206 .53538 L
s
.86535 .60954 m
.87148 .5821 L
s
.86577 .65649 m
.87105 .62887 L
s
.86609 .7034 m
.87073 .67567 L
s
.86634 .75031 m
.87048 .72249 L
s
.86655 .79719 m
.87028 .76933 L
s
.91223 .01977 m
.91831 .04722 L
s
.91166 .06677 m
.91888 .09394 L
s
.91085 .11387 m
.9197 .14056 L
s
.9096 .16121 m
.92095 .18694 L
s
.90753 .2092 m
.92301 .23267 L
s
.90411 .25924 m
.92643 .27634 L
s
.90122 .31443 m
.92933 .31488 L
s
.90394 .36983 m
.92661 .3532 L
s
.90742 .42003 m
.92313 .39672 L
s
.90953 .46807 m
.92102 .44241 L
s
.91081 .51543 m
.91974 .48877 L
s
.91164 .56254 m
.91891 .53538 L
s
.91221 .60954 m
.91833 .5821 L
s
.91263 .65649 m
.91791 .62887 L
s
.91296 .70341 m
.91759 .67567 L
s
.91321 .75031 m
.91734 .72249 L
s
.91341 .79719 m
.91713 .76933 L
s
.95909 .01977 m
.96518 .04722 L
s
.95852 .06677 m
.96575 .09394 L
s
.9577 .11387 m
.96656 .14055 L
s
.95645 .16122 m
.96782 .18693 L
s
.95437 .20921 m
.96989 .23266 L
s
.95095 .25928 m
.97332 .27631 L
s
.94808 .3145 m
.97619 .31481 L
s
.95083 .36987 m
.97344 .35316 L
s
.95429 .42005 m
.96997 .39671 L
s
.9564 .46807 m
.96787 .4424 L
s
.95767 .51543 m
.96659 .48877 L
s
.9585 .56254 m
.96577 .53538 L
s
.95908 .60954 m
.96519 .5821 L
s
.9595 .65649 m
.96477 .62887 L
s
.95982 .70341 m
.96445 .67567 L
s
.96007 .75031 m
.9642 .72249 L
s
.96027 .79719 m
.96399 .76933 L
s
0 0 m
1 0 L
1 .81672 L
0 .81672 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{244, 199.25},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003d0000ab000`400?l00000o`00003om?ooool0
0?Cooooo003dooooo`00m?ooool001Oooooo0ol0000Xooooo`03o`000?oooooooooo02?ooooo0ol0
000Yooooo`03o`000?oooooooooo02Oooooo0ol0000Wooooo`?o00002Oooool001;ooooo1?l00000
0ooooooo0000ooooo`0Sooooo`Co00000_ooool00ol0003oooooooooo`0Sooooo`04o`000?oooooo
ooooo`0002Sooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Yooooo`03o`000?oo
oooooooo00Oooooo000Hooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool08oooool0
1?l0003oooooooooool0000Xooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool0:?oo
ool00ol0003oooooooooo`07ooooo`006?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooo
oooo02?ooooo00Co0000oooooooooooo0000:?ooool00ol0003oooooooooo`0Xooooo`03o`000?oo
oooooooo02Sooooo00?o0000ooooooooool01oooool001Kooooo0ol0000Yooooo`03o`000?oooooo
oooo02?ooooo0ol0000Yooooo`03o`000?oooooooooo02Kooooo0ol0000Xooooo`?o00002Oooool0
0?Cooooo003dooooo`00m?ooool00?Cooooo000@ooooon?o00000Oooool0013ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo0Ol00001oooo
o`004?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02Sooooo00?o0000oooooooo
ool09oooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo02Oooooo00?o0000oooooooo
ool0:?ooool00ol0003oooooooooo`05ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool0
Eoooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool0Eooo
ool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool1
o`00007ooooo000@ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0Ol00001ooooo`002?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Kooooo0Ol00001ooooo`000oooool4o`000003oooo
ool0003ooooo00Kooooo0_l00003ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`05ooooo`;o00000Oooool000Sooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01ooo
ool2o`0000Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Gooooo0Ol00001ooooo`002?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`;o00002_ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01Oooool1
o`00007ooooo0008ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo0_l0000:ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`05ooooo`7o00000Oooool0013o
oooo00?o0000ooooooooool0Eoooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo
00?o0000ooooooooool0Eoooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o
0000ooooooooool0Eoooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01_ooool1o`00007ooooo000@ooooo`;o00000oooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool1o`00007ooooo000@ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Kooooo0Ol00001ooooo`004?ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`05ooooo`7o0000
0Oooool0013ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Oooooo0_l00009ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`05ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo0_l00009ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`05ooooo`7o00000Oooool0
013ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Oooooo0_l0000:ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`04ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Oooooo0_l0000:ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`04ooooo`7o00000Oooool0013ooooo
00?o0000ooooooooool0Eoooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o
0000ooooooooool0Eoooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo0_l0001H
ooooo`03o`000?oooooooooo08Gooooo0Ol00001ooooo`004?ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06oooo
o`7o00000Oooool0013ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool1o`00007ooooo000@ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Gooooo0Ol00001ooooo`004?ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`05ooooo`7o00000Ooo
ool0013ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00Oooooo0_l00009ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`05ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo0_l0000:ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`04ooooo`7o00000Oooool0013o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oo
oooo0_l0000:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`04ooooo`7o00000Oooool0013ooooo0_l0001Hooooo`03o`000?oooooooooo08Gooooo
0Ol00001ooooo`004?ooool00ol0003oooooooooo`1Gooooo`03o`000?oooooooooo08Gooooo0Ol0
0001ooooo`004?ooool00ol0003oooooooooo`1Gooooo`03o`000?oooooooooo08Gooooo0Ol00001
ooooo`004?ooool00ol0003oooooooooo`1Gooooo`03o`000?oooooooooo08Gooooo0Ol00001oooo
o`004?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01oooool2o`0000Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Kooooo0Ol00001ooooo`004?ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool2o`0000Wooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0Ol00001ooooo`004?oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`05ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01Oooool1
o`00007ooooo000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Gooooo0Ol00001ooooo`004?ooool2o`0000Co
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06ooooo`;o00002_ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01?ooool1o`00007o
oooo000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`06ooooo`;o00002_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool01?ooool1o`00007ooooo000@ooooo`03o`000?oooooooooo05Oooooo00?o
0000ooooooooool0QOooool1o`00007ooooo000@ooooo`03o`000?oooooooooo05Oooooo00?o0000
ooooooooool0QOooool1o`00007ooooo000@ooooo`03o`000?oooooooooo05Oooooo00?o0000oooo
ooooool0QOooool1o`00007ooooo000@ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`;o00002Oooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo077ooooo0Ol00001ooooo`004?ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool2o`0000Wooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo0Ol00001ooooo`001ooo
ool3o`0000Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool01oooool1o`00007ooooo0007ooooo`04o`000?oooooo
ooooo`0000Gooooohol00001ooooo`001oooool01?l0003oooooooooool00005ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`;o00002Ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01Ooo
ool1o`00007ooooo0007ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0_l0000:ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`04ooooo`7o00000Ooo
ool000Oooooo0ol00006ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooo000000Wooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00?ooooo0Ol00001ooooo`004?ooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0Aoooool00ol0
003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool0Eoooool00ol0003o
ooooooooo`25ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool0Eoooool00ol0003ooooo
ooooo`25ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool0Eoooool00ol0003ooooooooo
o`25ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Sooooo0_l00008ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool0LOooool1o`00007ooooo000@ooooo`;o00000oooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Sooooo0_l00008ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo0_l00009oooo
o`;o00002?ooool2o`0000Wooooo0_l00008ooooo`;o00002Oooool2o`0000Wooooo0_l00008oooo
o`;o00002Oooool1o`00007ooooo000@ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Kooooo0Ol00001ooooo`00
4?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`05ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo0_l00009ooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`04ooooo`7o00000Ooo
ool0013ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00Oooooo0_l0000:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`03ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooool000002_ooool00ol0
003oooooooooo`1hooooo`7o00000Oooool0013ooooo00?o0000ooooooooool0Eoooool00ol0003o
ooooooooo`25ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool0Eoooool00ol0003ooooo
ooooo`25ooooo`7o00000Oooool0013ooooo0_l0001Hooooo`03o`000?oooooooooo08Gooooo0Ol0
0001ooooo`004?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool0:?ooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ool00000Qoooool1o`00007ooooo000@ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`08ooooo`;o00001oooool2o`0000Wooooo0_l0001cooooo`7o
00000Oooool0013ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool2o`0000Wooooo0_l00006ooooo`?o0000
2?ooool4o`0000Kooooo1Ol00006ooooo`Co00001oooool4o`0000Kooooo1Ol00006ooooo`Co0000
1_ooool5o`0001cooooo0Ol00001ooooo`004?ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool01oooool2o`0000[ooooo0_l00009ooooo`;o00001ooo
ool3o`0000Wooooo0ol00008ooooo`?o00001oooool3o`0000Sooooo0ol00008ooooo`?o00001ooo
ool3o`0000Sooooo0ol00003ooooo`Oo00001?ooool7o`0000Cooooo0Ol00001ooooo`004?ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool0
0ol0003oooooo`00000;ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`1Rooooo`7o00000Oooool0013ooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo0000Q?ooool1
o`00007ooooo000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool0QOooool1o`00
007ooooo000@ooooo`;o0000F?ooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo
00?o0000ooooooooool0Eoooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o
0000ooooooooool0Eoooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool07_ooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`07ooooo`;o00002oooool00ol0003oooooooooo`0ooooo
o`;o00002?ooool2o`0000Wooooo0_l00009ooooo`;o00002?ooool2o`0000Wooooo0_l00008oooo
o`;o00001Oooool1o`00007ooooo000@ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`05ooooo`Co00005oooool2o`0000Sooooo0_l00009ooooo`;o
00002?ooool2o`0000Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool01Oooool1o`00007ooooo000@ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`07ooooo`?o0000
1Oooool7o`0000Kooooo0ol00007ooooo`?o00002Oooool2o`0000Sooooo0_l00008ooooo`;o0000
2Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo0_l00009ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`06ooooo`7o0000
0Oooool0013ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`09ooooo`03o`000?oo
oooooooo00Kooooo00Co0000oooooooooooo00003oooool2o`0000Sooooo0_l0000:ooooo`;o0000
2Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo0Ol00001ooooo`004?oo
ool2o`0000Cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo02Gooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo0Ol00001ooooo`004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo013ooooo00?o0000ooooooooool0QOooool1o`00007ooooo000@ooooo`03o`000?oooooooooo
05Oooooo00?o0000ooooooooool0QOooool1o`00007ooooo000@ooooo`03o`000?oooooooooo05Oo
oooo00?o0000ooooooooool0QOooool1o`00007ooooo000@ooooo`03o`000?oooooooooo05Oooooo
00?o0000ooooooooool0QOooool1o`00007ooooo000@ooooo`03o`000?oooooooooo05Oooooo00?o
0000ooooooooool0QOooool1o`00007ooooo000@ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01kooooo00?o0000
ooooooooool07oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`03ooooo`7o00000Oooool0013ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool01_ooool2o`0001Kooooo00Co0000ooooool0003o00002Oooool00ol0003oooooooooo`07
ooooo`;o00002Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`03ooooo`7o00000Oooool000Sooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`07ooooo`;o00005?ooool2o`0000[ooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Cooooo0Ol00001oooo
o`002?ooool00ol0003oooooooooo`05ooooo`;o00000oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool2o`0000Gooooo1ol00005ooooo`;o
00002_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01?ooool2o`00007ooooo0008ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooo000000Wooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0Ol00001ooooo`002?oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool1o`00007ooooo0008ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0QOooool1
o`00007ooooo000@ooooo`03o`000?oooooooooo05Oooooo00?o0000ooooooooool0QOooool1o`00
007ooooo000@ooooo`03o`000?oooooooooo05Oooooo00?o0000ooooooooool0QOooool1o`00007o
oooo000@ooooo`03o`000?oooooooooo05Oooooo00?o0000ooooooooool0QOooool1o`00007ooooo
000@ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0<_ooool00ol0003ooooooooo
o`25ooooo`7o00000Oooool0013ooooo0_l00003ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool01_ooool2o`0001Oooooo0_l00007ooooo`03o`000?oooooo000000[ooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Cooooo0Ol00001
ooooo`004?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ool000002_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01?ooool1o`00007ooooo000@ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo1?l00006ooooo`03
o`000?oooooooooo00Sooooo0_l0000:ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`05ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
0oooool3o`0000Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`06ooooo`7o0000
0Oooool0013ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`09ooooo`;o00002Ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01_oo
ool1o`00007ooooo000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`0Tooooo`03o`000?oooooo000000Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo0Ol00001ooooo`004?ooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool0QOooool1o`00
007ooooo000@ooooo`03o`000?oooooooooo05Oooooo00?o0000ooooooooool0QOooool1o`00007o
oooo000@ooooo`03o`000?oooooooooo05Oooooo00?o0000ooooooooool0QOooool1o`00007ooooo
000@ooooo`;o0000F?ooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo027ooooo00?o0000
ooooooooool01Oooool00ol0003oooooo`000009ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`04ooooo`7o00000Oooool0013ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01Kooooo0_l00009oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooool000002Oooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01?ooool1o`00007ooooo000@ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Dooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool2o`0000Wooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Gooooo0Ol00001ooooo`00
4?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1?ooool8o`0000Kooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`;o0000
2Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1Oooool1o`00007ooooo000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`05ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0Ol00001ooooo`004?ooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool06Oooool00ol0
003oooooooooo`08ooooo`;o00002Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01_ooool1o`00007ooooo000@ooooo`;o0000F?ooool00ol0003o
ooooooooo`25ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool0Eoooool00ol0003ooooo
ooooo`25ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool0Eoooool00ol0003ooooooooo
o`25ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo04Oooooo00?o0000ooooooooool0QOooool1o`00007ooooo000@oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Kooooo0_l0000:ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`04ooooo`7o00000Oooool0013ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`06ooooo`;o00003Oooool2o`0000Wooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`06ooooo`;o00002_ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01?ooool1o`00007ooooo000@ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`;o0000
2_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1Oooool1o`00007ooooo000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool2o`0000Oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool01Oooool1o`00007ooooo000@ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Gooooo0Ol00001ooooo`004?ooool2o`0000Cooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool2o`00
00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Kooooo0Ol00001ooooo`004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo02Ko
oooo00?o0000ooooooooool01oooool2o`0000Wooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0Ol00001ooooo`004?ooool00ol0003ooooo
ooooo`1Gooooo`03o`000?oooooooooo08Gooooo0Ol00001ooooo`004?ooool00ol0003ooooooooo
o`1Gooooo`03o`000?oooooooooo08Gooooo0Ol00001ooooo`004?ooool00ol0003oooooooooo`1G
ooooo`03o`000?oooooooooo08Gooooo0Ol00001ooooo`004?ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo01oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06oooo
o`;o00002_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool01Oooool1o`00007ooooo000@ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool05Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01_ooool2o`0000[ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Gooooo0Ol00001ooooo`002?ooool3o`0000Gooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`;o00002Oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01Oooool1o`00007ooooo0008ooooo`03o`000?oo
oooooooo00Gooooo0_l00003ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Gooooo1ol00007ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`;o00002Ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01?oo
ool2o`00007ooooo0009ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Kooooo0Ol00001ooooo`002Oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`06ooooo`7o00000Oooool000Oooooo0ol00006ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool03oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06ooooo`7o00000Oooool0013ooooo
00?o0000ooooooooool0Eoooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o
0000ooooooooool0Eoooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o0000
ooooooooool0Eoooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o0000oooo
ooooool0Eoooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool01_ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`06ooooo`;o00002_ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool01Oooool1o`00007ooooo000@ooooo`;o0000
0oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`0;ooooo`;o00002Oooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01_ooool2o`0000[ooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Gooooo0Ol00001ooooo`004?oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool2o`0000Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Gooooo0Ol00001ooooo`004?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01oooool2o`0000Wooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Gooooo0Ol00001ooooo`004?ooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`06ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01_ooool1o`00007o
oooo000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01_ooool1o`00007ooooo
000@ooooo`03o`000?oooooooooo05Oooooo00?o0000ooooooooool0QOooool1o`00007ooooo000@
ooooo`03o`000?oooooooooo05Oooooo00?o0000ooooooooool0QOooool1o`00007ooooo000@oooo
o`;o0000F?ooool00ol0003oooooooooo`25ooooo`7o00000Oooool0013ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool07oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool01oooool2o`0000[ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Gooooo0Ol00001ooooo`004?ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Eooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Oooooo0_l0000:ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`05ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01_oo
ool2o`0000gooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool01oooool2o`0000[ooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Gooooo0Ol00001ooooo`004?ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`;o00002_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`;o00002Oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01Oooool1
o`00007ooooo000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Kooooo0Ol00001ooooo`004?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`06ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool03oooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo00Kooooo0Ol00001ooooo`004?ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`0Kooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00Kooooo0Ol00001ooooo`004?ooool2o`0005Sooooo00?o0000
ooooooooool0QOooool1o`00007ooooo000@ooooo`03o`000?oooooooooo05Oooooo00?o0000oooo
ooooool0QOooool1o`00007ooooo000@ooooo`03o`000?oooooooooo05Oooooo00?o0000oooooooo
ool0QOooool1o`00007ooooo000@ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
1oooool2o`0000[ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Gooooo0Ol00001ooooo`004?ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Dooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Oooooo0_l0000:ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`05ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool2
o`0000Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool01oooool2o`0000[ooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Gooooo0Ol00001ooooo`004?ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`06ooooo`?o00002Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`;o00002_ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01Oooool1o`00
007ooooo000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Cooooo0_l0000<ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool01_ooool1o`00007ooooo000@ooooo`;o00001?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool04?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo00Kooooo0Ol00001ooooo`004?ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`0@ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01_ooool1o`00007ooooo000@
ooooo`03o`000?oooooooooo05Oooooo00?o0000ooooooooool0QOooool1o`00007ooooo000@oooo
o`03o`000?oooooooooo05Oooooo00?o0000ooooooooool0QOooool1o`00007ooooo000@ooooo`03
o`000?oooooooooo05Oooooo00?o0000ooooooooool0QOooool1o`00007ooooo000@ooooo`03o`00
0?oooooooooo05Oooooo00?o0000ooooooooool0QOooool1o`00007ooooo000@ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`;o00002Ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01Ooo
ool1o`00007ooooo000@ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`07ooooo`;o00002Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool01Oooool1o`00007ooooo0007ooooo`?o00001_ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool2o`00
00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Gooooo0Ol00001ooooo`002Oooool00ol0003oooooooooo`04ooooo`;o00000oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Oooooo0_l00009ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`04ooooo`;o00000Oooool000Wooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`06ooooo`7o00000Oooool000Wooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`06ooooo`7o00000Oooool000Oooooo0ol00006
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`06
ooooo`7o00000Oooool0013ooooo00?o0000ooooooooool0Eoooool00ol0003oooooooooo`25oooo
o`7o00000Oooool0013ooooo00?o0000ooooooooool0Eoooool00ol0003oooooooooo`25ooooo`7o
00000Oooool0013ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Gooooo0Ol00001ooooo`004?oooooSo`00007ooooo0000\
\>"],
  ImageRangeCache->{{{0, 243}, {198.25, 0}} -> {-2.5176, -1.48555, 0.0235498, \
0.0235498}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Select some sample solutions"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Solve the differential equation."], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \(Exp[\(-\(\(3\ t\)\/2\)\)] - 3\ y[t] + 3\/2\)}], 
        ",", \(y[t]\), ",", "t"}], "]"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{y[
            t] \[Rule] \[ExponentialE]\^\(\(-3\)\ t\)\ \((2\/3\ \
\[ExponentialE]\^\(\(3\ t\)/2\) + \[ExponentialE]\^\(3\ t\)\/2)\) + \
\[ExponentialE]\^\(\(-3\)\ t\)\ C[1]}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Capture the solutions."], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(soln[t_] = \(y[t] /. First[%]\) /. C[1] \[Rule] c\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(c\ \[ExponentialE]\^\(\(-3\)\ t\) + \[ExponentialE]\^\(\(-3\)\ t\)\ \
\((2\/3\ \[ExponentialE]\^\(\(3\ t\)/2\) + \[ExponentialE]\^\(3\ \
t\)\/2)\)\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Select the solutions to be plotted."], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(theSolns = 
      Table[soln[t], {c, \(- .5\),  .5,  .25}] \[Union] {soln[t] /. 
            c \[Rule] 2, soln[t] /. c \[Rule] \(- .1\)}\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({\(-0.5`\)\ \[ExponentialE]\^\(\(-3\)\ t\) + \[ExponentialE]\^\(\(-3\)\ \
t\)\ \((2\/3\ \[ExponentialE]\^\(\(3\ t\)/2\) + \[ExponentialE]\^\(3\ t\)\/2)\
\), \(-0.25`\)\ \[ExponentialE]\^\(\(-3\)\ t\) + \[ExponentialE]\^\(\(-3\)\ t\
\)\ \((2\/3\ \[ExponentialE]\^\(\(3\ t\)/2\) + \[ExponentialE]\^\(3\ \
t\)\/2)\), \(-0.1`\)\ \[ExponentialE]\^\(\(-3\)\ t\) + \
\[ExponentialE]\^\(\(-3\)\ t\)\ \((2\/3\ \[ExponentialE]\^\(\(3\ t\)/2\) + \
\[ExponentialE]\^\(3\ t\)\/2)\), 
      0.`\ \[ExponentialE]\^\(\(-3\)\ t\) + \[ExponentialE]\^\(\(-3\)\ t\)\ \
\((2\/3\ \[ExponentialE]\^\(\(3\ t\)/2\) + \[ExponentialE]\^\(3\ t\)\/2)\), 
      0.25`\ \[ExponentialE]\^\(\(-3\)\ t\) + \[ExponentialE]\^\(\(-3\)\ t\)\ \
\((2\/3\ \[ExponentialE]\^\(\(3\ t\)/2\) + \[ExponentialE]\^\(3\ t\)\/2)\), 
      0.5`\ \[ExponentialE]\^\(\(-3\)\ t\) + \[ExponentialE]\^\(\(-3\)\ t\)\ \
\((2\/3\ \[ExponentialE]\^\(\(3\ t\)/2\) + \[ExponentialE]\^\(3\ t\)\/2)\), 
      2\ \[ExponentialE]\^\(\(-3\)\ t\) + \[ExponentialE]\^\(\(-3\)\ t\)\ \
\((2\/3\ \[ExponentialE]\^\(\(3\ t\)/2\) + \[ExponentialE]\^\(3\ \
t\)\/2)\)}\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Plot the sample solutions"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(curves = 
        Plot[Evaluate[theSolns], {t, \(-2\), 3}, 
          PlotRange \[Rule] {\(-1\), 3}];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.190476 0.154508 0.154508 [
[.02381 .14201 -6.75 -10 ]
[.02381 .14201 6.75 0 ]
[.21429 .14201 -6.75 -10 ]
[.21429 .14201 6.75 0 ]
[.59524 .14201 -4 -10 ]
[.59524 .14201 4 0 ]
[.78571 .14201 -4 -10 ]
[.78571 .14201 4 0 ]
[.97619 .14201 -4 -10 ]
[.97619 .14201 4 0 ]
[.39226 0 -13.5 -5 ]
[.39226 0 0 5 ]
[.39226 .07725 -19.5 -5 ]
[.39226 .07725 0 5 ]
[.39226 .23176 -14 -5 ]
[.39226 .23176 0 5 ]
[.39226 .30902 -8 -5 ]
[.39226 .30902 0 5 ]
[.39226 .38627 -14 -5 ]
[.39226 .38627 0 5 ]
[.39226 .46353 -8 -5 ]
[.39226 .46353 0 5 ]
[.39226 .54078 -14 -5 ]
[.39226 .54078 0 5 ]
[.39226 .61803 -8 -5 ]
[.39226 .61803 0 5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .15451 m
.02381 .16076 L
s
gsave
.02381 .14201 -67.75 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.500 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.21429 .15451 m
.21429 .16076 L
s
gsave
.21429 .14201 -67.75 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.500 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.59524 .15451 m
.59524 .16076 L
s
gsave
.59524 .14201 -65 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.78571 .15451 m
.78571 .16076 L
s
gsave
.78571 .14201 -65 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.97619 .15451 m
.97619 .16076 L
s
gsave
.97619 .14201 -65 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.125 Mabswid
.0619 .15451 m
.0619 .15826 L
s
.1 .15451 m
.1 .15826 L
s
.1381 .15451 m
.1381 .15826 L
s
.17619 .15451 m
.17619 .15826 L
s
.25238 .15451 m
.25238 .15826 L
s
.29048 .15451 m
.29048 .15826 L
s
.32857 .15451 m
.32857 .15826 L
s
.36667 .15451 m
.36667 .15826 L
s
.44286 .15451 m
.44286 .15826 L
s
.48095 .15451 m
.48095 .15826 L
s
.51905 .15451 m
.51905 .15826 L
s
.55714 .15451 m
.55714 .15826 L
s
.63333 .15451 m
.63333 .15826 L
s
.67143 .15451 m
.67143 .15826 L
s
.70952 .15451 m
.70952 .15826 L
s
.74762 .15451 m
.74762 .15826 L
s
.82381 .15451 m
.82381 .15826 L
s
.8619 .15451 m
.8619 .15826 L
s
.9 .15451 m
.9 .15826 L
s
.9381 .15451 m
.9381 .15826 L
s
.25 Mabswid
0 .15451 m
1 .15451 L
s
.40476 0 m
.41101 0 L
s
gsave
.39226 0 -74.5 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.500 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.40476 .07725 m
.41101 .07725 L
s
gsave
.39226 .07725 -80.5 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.500 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.40476 .23176 m
.41101 .23176 L
s
gsave
.39226 .23176 -75 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.40476 .30902 m
.41101 .30902 L
s
gsave
.39226 .30902 -69 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.40476 .38627 m
.41101 .38627 L
s
gsave
.39226 .38627 -75 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
1.000 setlinewidth
grestore
.40476 .46353 m
.41101 .46353 L
s
gsave
.39226 .46353 -69 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.40476 .54078 m
.41101 .54078 L
s
gsave
.39226 .54078 -75 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.5) show
1.000 setlinewidth
grestore
.40476 .61803 m
.41101 .61803 L
s
gsave
.39226 .61803 -69 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.125 Mabswid
.40476 .01545 m
.40851 .01545 L
s
.40476 .0309 m
.40851 .0309 L
s
.40476 .04635 m
.40851 .04635 L
s
.40476 .0618 m
.40851 .0618 L
s
.40476 .09271 m
.40851 .09271 L
s
.40476 .10816 m
.40851 .10816 L
s
.40476 .12361 m
.40851 .12361 L
s
.40476 .13906 m
.40851 .13906 L
s
.40476 .16996 m
.40851 .16996 L
s
.40476 .18541 m
.40851 .18541 L
s
.40476 .20086 m
.40851 .20086 L
s
.40476 .21631 m
.40851 .21631 L
s
.40476 .24721 m
.40851 .24721 L
s
.40476 .26266 m
.40851 .26266 L
s
.40476 .27812 m
.40851 .27812 L
s
.40476 .29357 m
.40851 .29357 L
s
.40476 .32447 m
.40851 .32447 L
s
.40476 .33992 m
.40851 .33992 L
s
.40476 .35537 m
.40851 .35537 L
s
.40476 .37082 m
.40851 .37082 L
s
.40476 .40172 m
.40851 .40172 L
s
.40476 .41717 m
.40851 .41717 L
s
.40476 .43262 m
.40851 .43262 L
s
.40476 .44807 m
.40851 .44807 L
s
.40476 .47898 m
.40851 .47898 L
s
.40476 .49443 m
.40851 .49443 L
s
.40476 .50988 m
.40851 .50988 L
s
.40476 .52533 m
.40851 .52533 L
s
.40476 .55623 m
.40851 .55623 L
s
.40476 .57168 m
.40851 .57168 L
s
.40476 .58713 m
.40851 .58713 L
s
.40476 .60258 m
.40851 .60258 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.2875 0 m
.29441 .03811 L
.30459 .08424 L
.31417 .1202 L
.32439 .15179 L
.34278 .19452 L
.35306 .21213 L
.36419 .22718 L
.3747 .23824 L
.38436 .24619 L
.3941 .25241 L
.40319 .25686 L
.41316 .26049 L
.41875 .26205 L
.42385 .2632 L
.42866 .26408 L
.43376 .26481 L
.43812 .26529 L
.44293 .26568 L
.44562 .26584 L
.44809 .26595 L
.44938 .26599 L
.45079 .26603 L
.45151 .26605 L
.45227 .26606 L
.45298 .26607 L
.45364 .26608 L
.45494 .26609 L
.45563 .2661 L
.45635 .2661 L
.45757 .26609 L
.45826 .26609 L
.45891 .26608 L
.46011 .26607 L
.46122 .26605 L
.46369 .26599 L
.4662 .2659 L
.46848 .26581 L
.47357 .26554 L
.48272 .26488 L
.50346 .26279 L
.54357 .25761 L
.58218 .25251 L
.62323 .24772 L
.66277 .24394 L
.7008 .24104 L
.74127 .23865 L
.78023 .23691 L
.82165 .23552 L
.86154 .23453 L
Mistroke
.89993 .23382 L
.94076 .23326 L
.97619 .2329 L
Mfstroke
.22496 0 m
.23475 .06261 L
.24462 .11413 L
.26314 .18655 L
.27273 .21407 L
.28295 .23749 L
.29252 .2548 L
.30133 .2674 L
.31162 .27876 L
.31692 .28341 L
.32275 .28769 L
.33255 .29321 L
.33791 .29544 L
.34292 .29709 L
.34792 .29837 L
.35056 .2989 L
.35337 .29937 L
.35581 .29971 L
.35851 .3 L
.35969 .3001 L
.36096 .3002 L
.36216 .30027 L
.36327 .30032 L
.36436 .30037 L
.36552 .3004 L
.36681 .30042 L
.36798 .30043 L
.36921 .30043 L
.3699 .30042 L
.37054 .30041 L
.37171 .30038 L
.37295 .30034 L
.37513 .30024 L
.37718 .30012 L
.38182 .29973 L
.3868 .29916 L
.39223 .2984 L
.40211 .29667 L
.42065 .29258 L
.46135 .28189 L
.50053 .27167 L
.54216 .26224 L
.58228 .25486 L
.62088 .24926 L
.66194 .24468 L
.70148 .24136 L
.7395 .23894 L
.77998 .23702 L
.81894 .23565 L
.86035 .23458 L
Mistroke
.90025 .23383 L
.93863 .23329 L
.97619 .2329 L
Mfstroke
.13476 0 m
.14357 .09222 L
.15301 .16508 L
.16341 .22933 L
.17427 .28156 L
.18444 .31914 L
.19482 .3482 L
.20469 .36866 L
.21354 .38212 L
.21856 .38798 L
.22321 .39243 L
.22829 .39628 L
.23096 .39793 L
.23378 .39941 L
.23625 .4005 L
.23896 .40147 L
.24146 .40218 L
.24373 .40269 L
.24488 .40289 L
.24612 .40307 L
.24719 .4032 L
.24838 .4033 L
.24963 .40338 L
.25032 .40341 L
.25096 .40343 L
.25212 .40344 L
.25336 .40342 L
.25445 .40337 L
.25564 .40329 L
.25689 .40318 L
.25804 .40305 L
.26012 .40276 L
.26234 .40236 L
.26767 .40109 L
.27258 .39955 L
.28369 .39501 L
.30384 .38408 L
.34324 .35826 L
.38113 .33342 L
.42147 .31019 L
.46029 .29184 L
.50157 .27646 L
.54133 .2651 L
.57958 .25678 L
.62027 .25012 L
.65945 .24534 L
.70109 .2416 L
.74121 .23897 L
.77981 .23709 L
.82087 .23563 L
Mistroke
.86041 .2346 L
.89843 .23387 L
.93891 .23329 L
.97619 .23291 L
Mfstroke
.23832 .61803 m
.26171 .54953 L
.30316 .46104 L
.34309 .39918 L
.3815 .35548 L
.42237 .32143 L
.46172 .29754 L
.49955 .28059 L
.53984 .26732 L
.57861 .25796 L
.61984 .2507 L
.65954 .24561 L
.69774 .24202 L
.73838 .23921 L
.77751 .23723 L
.81909 .23571 L
.85916 .23464 L
.89771 .23389 L
.93871 .2333 L
.97619 .23291 L
s
.31122 .61803 m
.32572 .55785 L
.34581 .49338 L
.384 .40663 L
.40368 .37495 L
.42465 .34808 L
.44462 .32763 L
.46623 .30991 L
.5063 .28587 L
.52624 .27704 L
.5473 .26938 L
.58527 .25887 L
.60478 .25474 L
.6257 .25104 L
.66706 .24544 L
.7069 .24163 L
.74523 .239 L
.78602 .23697 L
.82528 .23557 L
.86303 .23458 L
.90324 .23381 L
.94192 .23327 L
.97619 .23291 L
s
.34045 .61803 m
.34581 .59113 L
.36562 .51507 L
.384 .46019 L
.40453 .4125 L
.42313 .37874 L
.444 .34903 L
.4632 .32755 L
.50175 .29652 L
.52058 .28561 L
.54124 .27593 L
.56238 .26799 L
.58166 .2621 L
.62057 .25317 L
.63966 .24987 L
.66042 .2469 L
.6798 .24459 L
.7012 .24247 L
.74046 .23948 L
.78067 .23731 L
.81936 .23581 L
.8605 .23467 L
.90012 .23388 L
.93823 .23332 L
.97619 .23292 L
s
.40996 .61803 m
.42313 .55227 L
.44238 .47923 L
.4632 .41988 L
.48314 .37725 L
.5042 .34337 L
.52384 .31946 L
.54217 .30215 L
.56253 .28725 L
.58108 .27668 L
.60017 .26811 L
.62093 .2608 L
.6407 .25535 L
.66171 .25078 L
.69946 .24486 L
.71881 .24265 L
.73966 .24071 L
.75931 .23924 L
.7808 .23792 L
.82043 .23611 L
.84004 .23543 L
.86099 .23483 L
.8809 .23436 L
.90249 .23393 L
.94247 .23332 L
.97619 .23295 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.812, 174.188},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00Joooool00ol0003ooooooooo
o`2[ooooo`00IOooool4o`0000;ooooo00?o0000ooooooooool01Oooool3o`000:?ooooo000/oooo
o`03o`000?oooooooooo01Gooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Doooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0Xoooool002cooooo00?o0000oooooooo
ool05Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01Cooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`2Sooooo`00;?ooool00ol0003oooooooooo`0Eooooo`03o`00
0?oooooooooo00kooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo0:?ooooo000/ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0Kooooo`;o0000Y?ooool002cooooo00?o0000ooooooooool05_ooool0
0ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool0Xoooool0
02cooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo
01_ooooo00?o0000ooooooooool0Xoooool002gooooo00?o0000ooooooooool05Oooool00ol0003o
ooooooooo`0=ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool0Xoooool002gooooo
00?o0000ooooooooool05Oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01[ooooo
0_l0002Tooooo`00;Oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00kooooo00?o
0000ooooooooool06_ooool00ol0003oooooooooo`2Sooooo`00;Oooool00ol0003oooooooooo`0E
ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`2S
ooooo`00;Oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool06_ooool00ol0003oooooooooo`2Sooooo`00;Oooool00ol0003oooooooooo`0Eooooo`03
o`000?oooooooooo00kooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`2Sooooo`00
;Oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0
6Oooool2o`000:Cooooo000]ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo0:?ooooo000]ooooo`03o`000?oooooo
oooo01Kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooo
oooo0:?ooooo000]ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool03_ooool00ol0
003oooooooooo`0Iooooo`03o`000?oooooooooo0:?ooooo000]ooooo`03o`000?oooooooooo01Ko
oooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0Hooooo`;o0000Y?ooool002gooooo
00?o0000ooooooooool05_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo01Sooooo
00?o0000ooooooooool0Xoooool002gooooo00?o0000ooooooooool05_ooool00ol0003ooooooooo
o`0?ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0Xoooool002kooooo00?o0000
ooooooooool05_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00Wooooo0ol00002
ooooo`Co00001_ooool00ol0003oooooooooo`2Sooooo`00;_ooool00ol0003oooooooooo`0Foooo
o`03o`000?oooooooooo00kooooo00?o0000ooooooooool01?ooool4o`000005ooooool0003ooooo
ooooool000001?ooool00ol0003oooooooooo`04ooooo`?o0000Xoooool002kooooo00?o0000oooo
ooooool05_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Sooooo00Co0000oooo
oooooooo00001?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo0:?ooooo000^oooo
o`03o`000?oooooooooo01Kooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`08oooo
o`04o`000?ooooooooooo`0000?ooooo0_l00006ooooo`03o`000?oooooooooo0:?ooooo000^oooo
o`03o`000?oooooooooo01Oooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`08oooo
o`?o00000oooool3o`0000Kooooo00?o0000ooooooooool0Xoooool002kooooo00?o0000oooooooo
ool05oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01Oooooo0_l0002Tooooo`00
;_ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0
5_ooool00ol0003oooooooooo`2Sooooo`00;_ooool00ol0003oooooooooo`0Gooooo`03o`000?oo
oooooooo00oooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`2Sooooo`00;_ooool0
0ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool05_ooool0
0ol0003oooooooooo`2Sooooo`00;oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo
00kooooo00?o0000ooooooooool05_ooool2o`000:Cooooo000_ooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo0:?o
oooo000_ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool03oooool00ol0003ooooo
ooooo`0Eooooo`03o`000?oooooooooo0:?ooooo000@ooooo`?o00007?ooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool03oooool00ol0003ooooooooo
o`0Eooooo`03o`000?oooooooooo02kooooo00?o0000ooooooooool0<?ooool3o`0002kooooo0ol0
000>ooooo`002oooool4o`000003ooooool0003ooooo01gooooo00?o0000ooooooooool02oooool4
o`0000;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo01Gooooo0_l0000_ooooo`03o`000?oooooooooo033ooooo00?o0000ooooooooool0<?ooool0
0ol0003oooooooooo`0<ooooo`004Oooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo
01Cooooo00?o0000ooooooooool0;_ooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo
02oooooo00?o0000ooooooooool03?ooool0017ooooo00?o0000ooooooooool07?ooool00ol0003o
ooooooooo`0@ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool03oooool00ol0003o
ooooooooo`0Dooooo`03o`000?oooooooooo02kooooo00?o0000ooooooooool0<Oooool00ol0003o
ooooooooo`0_ooooo`03o`000?oooooooooo00cooooo000?ooooo`?o00007_ooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool03oooool00ol0003ooooo
ooooo`0Dooooo`03o`000?oooooooooo02kooooo00?o0000ooooooooool0;oooool3o`0002oooooo
0ol0000>ooooo`00<?ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00oooooo00?o
0000ooooooooool04oooool2o`000:Cooooo000`ooooo`03o`000?oooooooooo01Sooooo00?o0000
ooooooooool03oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo0:?ooooo000`oooo
o`03o`000?oooooooooo01Sooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0Coooo
o`03o`000?oooooooooo0:?ooooo000`ooooo`03o`000?oooooooooo01Sooooo00?o0000oooooooo
ool04?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0:?ooooo0008oooooooo0000
2_l00008ooooo`003_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool01oooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`07ooooo`;o00002?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0<ooooo`003_oo
ool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0;ooo
ool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool03?oo
ool0037ooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool0Xoooool0037ooooo00?o0000ooooooooool06Oooool00ol0
003oooooooooo`0@ooooo`03o`000?oooooooooo013ooooo0_l0002Tooooo`00<Oooool00ol0003o
ooooooooo`0Iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04?ooool00ol0003o
ooooooooo`2Sooooo`00<Oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool03oooool00ol0003oooooooooo`2Sooooo`00<Oooool00ol0003ooooooooo
o`0Iooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool03oooool00ol0003ooooooooo
o`2Sooooo`00<_ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool03_ooool2o`000:Cooooo000booooo`03o`000?oooooooooo01Wooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo0:?ooooo000booooo`03
o`000?oooooooooo01Wooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0>ooooo`03
o`000?oooooooooo0:?ooooo000booooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo0:?ooooo000booooo`03o`000?oo
oooooooo01[ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0=ooooo`;o0000Y?oo
ool003;ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool0Xoooool003;ooooo00?o0000ooooooooool06_ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0Xoooool003;o
oooo00?o0000ooooooooool06oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool0Xoooool003;ooooo00?o0000ooooooooool06oooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo00_ooooo0_l0002Tooooo`00<oooool00ol0003ooooooooo
o`0Jooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`2Sooooo`00<oooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo01?ooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`2Sooooo`00<oooool00ol0003oooooooooo`0Koooo
o`03o`000?oooooooooo01Cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`2Soooo
o`00<oooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo00oooooo0ol00002ooooo`Co
00001_ooool00ol0003oooooooooo`2Sooooo`00<oooool00ol0003oooooooooo`0Looooo`03o`00
0?oooooooooo00oooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000006ooooo`?o
0000I_ooool_o`0000kooooo000cooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool0
3_ooool01?l0003oooooooooool00003ooooo`;o00001_ooool00ol0003oooooooooo`1@ooooob7o
0000<_ooool003Cooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`0>ooooo`04o`00
0?ooooooooooo`0000?ooooo0ol00005ooooo`03o`000?oooooooooo04Gooooo5_l00018ooooo`00
=?ooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo00gooooo0ol00003ooooo`?o0000
00?oooooo`000?ooool00oooool00ol0003oooooooooo`0koooooa?o0000EOooool003Cooooo00?o
0000ooooooooool07Oooool00ol0003oooooooooo`0Hooooo`04o`000?ooooooooooooooo`;o0000
<ooooolAo`000003ooooool0003o000000?o0000F_ooool003Cooooo00?o0000ooooooooool07Ooo
ool00ol0003oooooooooo`0Iooooo`Co0000:OoooolCo`0000Cooooo1_l0001Oooooo`00=?ooool0
0ol0003oooooooooo`0Nooooo`03o`000?oooooooooo01_ooooo0_l0000Pooooo`So00000_ooool<
o`0000Cooooo1Ol0001Uooooo`00=Oooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo
01[ooooo00Co0000ooooool0003o00006Oooool5o`0000Gooooo1Ol00002ooooo`Ko00001?ooool4
o`0006[ooooo000eooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool06Oooool2o`00
00;ooooo1ol00006ooooo`co00001?ooool@o`0000Cooooo0ol0001^ooooo`00=Oooool00ol0003o
ooooooooo`0Pooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool02?ooool6o`0000_o
oooo4Ol00006ooooo`;o0000LOooool003Gooooo00?o0000ooooooooool08?ooool00ol0003ooooo
ooooo`0Hooooo`03o`000?oooooooooo01Cooooo3_l000001?oooooo0000o`000?l00007ooooo`?o
0000Loooool003Gooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`0Gooooo`03o`00
0?oooooooooo017ooooo0ol00002ooooo`Go000000Goooooo`000?l0003o0000ooooo`03o`0000So
oooo0_l0001fooooo`00=_ooool00ol0003oooooooooo`0Qooooo`;o00005oooool2o`0000oooooo
0ol00002ooooo`Go00000_ooool2o`0000;ooooo0_l00009ooooo`;o0000N?ooool003Kooooo00?o
0000ooooooooool08oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00[ooooo1?l0
0002ooooo`Go00001?ooool01Ol0003ooooooooooooooooo000000[ooooo00?o0000ooooooooool0
N?ooool003Kooooo00?o0000ooooooooool09?ooool2o`0001Cooooo00?o0000ooooooooool01_oo
ool4o`0000?ooooo0ol000000ooooooo0000o`000004ooooo`;o00000_ooool2o`0000Wooooo0_l0
001kooooo`00=_ooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool00oooool3o`0000Gooooo0_l00002ooooo`;o00001?ooool2o`0000;ooooo0_l0000:
ooooo`03o`000?oooooooooo07_ooooo000gooooo`03o`000?oooooooooo02Kooooo0ol0000@oooo
o`Ko00001_ooool2o`0000;ooooo0_l00004ooooo`;o00000oooool00ol0003oooooooooo`08oooo
o`;o0000O_ooool003Oooooo00?o0000ooooooooool0:Oooool4o`0000Kooooo2?l00007ooooo`?o
00000_ooool2o`0000Gooooo00Co0000oooooooooooooooo0_l0000:ooooo`03o`000?oooooooooo
07kooooo000gooooo`03o`000?oooooooooo02gooooo1_l00006ooooo`03o`000?oooooooooo00Co
oooo0_l00003ooooo`;o00001Oooool2o`0000?ooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`1oooooo`00>?ooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool00_ooool2o`0000Cooooo00?o0000ooooooooool00oooool2o`0000Cooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`20ooooo`00>?ooool00ol0003ooooooooo
o`0`ooooo`03o`000?oooooooooo00Gooooo1Ol00004ooooo`;o00001Oooool00ol0003ooooooooo
o`02ooooo`;o00002oooool00ol0003oooooooooo`21ooooo`00>?ooool00ol0003oooooooooo`0`
ooooo`03o`000?oooooooooo00Gooooo0ol00004ooooo`;o00001_ooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0P_ooool003Wooooo00?o0000oooo
ooooool0;oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool01Oooool01?l0003oooooooooooooool2o`0000cooooo00?o0000ooooooooool0Poooool0
03Wooooo00?o0000ooooooooool0;oooool00ol0003oooooooooo`03ooooo`?o00000oooool2o`00
00Oooooo00Go0000ooooooooooooooooo`00000=ooooo`03o`000?oooooooooo08Cooooo000ioooo
o`03o`000?oooooooooo03?ooooo0_l00002ooooo`;o000000?oooooo`000?ooool01oooool01Ol0
003ooooooooooooooooo000000kooooo00?o0000ooooooooool0Q?ooool003[ooooo00?o0000oooo
ooooool0<Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000Oooooo0_l00003oooo
o`03o`000?oooooooooo00cooooo00?o0000ooooooooool0QOooool003[ooooo00?o0000oooooooo
ool0;oooool2o`0000Gooooo0_l00007ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool03?ooool00ol0003oooooooooo`26ooooo`00>oooool00ol0003oooooooooo`0]ooooo`03o`00
0?oooooooooo00Cooooo0_l00007ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
3?ooool00ol0003oooooooooo`27ooooo`00>oooool00ol0003oooooooooo`0[ooooo`;o00001_oo
ool01?l0003oooooo`000?l00005ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
3?ooool00ol0003oooooooooo`28ooooo`00>oooool00ol0003oooooooooo`0Zooooo`03o`000?oo
oooooooo00Gooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00cooooo00?o0000ooooooooool0ROooool003cooooo00?o0000ooooooooool0:?oo
ool00ol0003oooooooooo`05ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0ROooool003cooooo00?o
0000ooooooooool09_ooool2o`0000Oooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool03?ooool00ol0003ooooooooo
o`2:ooooo`00?Oooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool00oooool2o`0000;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0=
ooooo`03o`000?oooooooooo08[ooooo000mooooo`03o`000?oooooooooo02;ooooo0_l00009oooo
o`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`0=
ooooo`03o`000?oooooooooo08_ooooo000mooooo`03o`000?oooooooooo027ooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo000000Gooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`2<ooooo`00?_ooool00ol0003oooooooooo`0Nooooo`;o
00002_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo000000Cooooo00?o0000oooooooo
ool03Oooool00ol0003oooooooooo`2<ooooo`00?_ooool00ol0003oooooooooo`0Looooo`;o0000
2oooool00ol0003oooooooooo`06ooooo`;o00001Oooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo08gooooo000oooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool03Ooo
ool00ol0003oooooooooo`2=ooooo`00@?ooool00ol0003oooooooooo`0Gooooo`;o00003?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool03Oooool0
0ol0003oooooooooo`2>ooooo`00@Oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool01Ol00005ooooo`;o00001?ooool00ol0003oooooooooo`0=oooo
o`03o`000?oooooooooo08kooooo0011ooooo`03o`000?oooooooooo01?ooooo0_l0000<ooooo`03
o`000?oooooo000000Cooooo00?o0000ooooooooool00oooool4o`000003ooooool0003ooooo00ko
oooo00?o0000ooooooooool0Soooool004;ooooo00?o0000ooooooooool04?ooool2o`0000kooooo
0_l00005ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool000000oooool00ol0003ooooo
ooooo`0=ooooo`03o`000?oooooooooo08oooooo0013ooooo`03o`000?oooooooooo00kooooo00?o
0000ooooooooool03_ooool00ol0003oooooooooo`03ooooo`;o00000oooool01?l0003ooooooooo
ool00002ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0T?ooool004Cooooo0_l0
000<ooooo`;o00004?ooool2o`0000Cooooo0ol00003ooooo`06o`000?ooooooooooo`000?oooooo
00004?ooool00ol0003oooooooooo`2@ooooo`00A_ooool2o`0000Kooooo1?l0000Aooooo`03o`00
0?oooooooooo00Wooooo00Co0000oooooooooooooooo0ol0000?ooooo`03o`000?oooooooooo097o
oooo0018ooooo`Ko00005Oooool00ol0003oooooooooo`09ooooo`04o`000?ooooooooooooooo`;o
00003oooool00ol0003oooooooooo`2Booooo`00H_ooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo00;ooooo0_l0000?ooooo`03o`000?oooooooooo09;ooooo001Qooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0=ooooo`03o`000?oo
oooooooo09?ooooo001Qooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00oooool2
o`0000kooooo00?o0000ooooooooool0Toooool0063ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`02ooooo`;o00003_ooool00ol0003oooooooooo`2Dooooo`00Goooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo0_l0000>ooooo`03o`000?oooooooooo09Co
oooo001Oooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool2o`0000kooooo
00?o0000ooooooooool0U?ooool005kooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooo000000gooooo00?o0000ooooooooool0UOooool005gooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`03ooooo`04o`000?oooooo0000o`0000cooooo00?o
0000ooooooooool0UOooool005cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`03
ooooo`04o`000?ooooooooooo`0000gooooo00?o0000ooooooooool0UOooool005cooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000cooooo00?o
0000ooooooooool0U_ooool005_ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`04
ooooo`04o`000?ooooooooooo`0000cooooo00?o0000ooooooooool0U_ooool005[ooooo00?o0000
ooooooooool03?ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooooooo`;o00002ooo
ool00ol0003oooooooooo`2Fooooo`00F_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo
oooo00Cooooo00Go0000ooooooooooooooooo`00000;ooooo`03o`000?oooooooooo09Oooooo001I
ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooo
oooo000000_ooooo00?o0000ooooooooool0Uoooool005Sooooo00?o0000ooooooooool03Oooool0
0ol0003oooooooooo`04o`0000Cooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`2G
ooooo`00F?ooool00ol0003oooooooooo`0<ooooo`05o`000?ooooooooooooooool000000_ooool0
0ol0003oooooooooo`02ooooo`?o00002?ooool00ol0003oooooooooo`2Hooooo`00Eoooool00ol0
003oooooooooo`0=ooooo`03o`000?oooooooooo00;ooooo0_l00005ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool0V?ooool005Oooooo00?o0000ooooooooool03?ooool00ol0003o
ooooooooo`03ooooo`;o00001Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo09So
oooo001Fooooo`03o`000?oooooooooo00gooooo00Co0000oooooooooooooooo1?l00005ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool0VOooool005Kooooo00?o0000ooooooooool0
3?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo0_l00008ooooo`03o`00
0?oooooooooo09Wooooo001Eooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0VOoo
ool005Gooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`2Iooooo`00E?ooool00ol0
003oooooooooo`0=ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo09[ooooo001Dooooo`03o`000?oooooooooo00co
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`;o00001oooool00ol0003o
ooooooooo`2Jooooo`00Doooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo09[ooooo
001Cooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0V_ooool005;ooooo00?o0000
ooooooooool03Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`2Kooooo`00D_ooool00ol0003oooooooooo`0=oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool2o`0000Kooooo00?o0000oooo
ooooool0Voooool005;ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`2Kooooo`00
DOooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo09cooooo001Aooooo`03o`000?oo
oooooooo00gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool0W?ooool0053ooooo00?o0000ooooooooool03_ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Sooooo0_l00005ooooo`03o`000?oooooo
oooo09cooooo001@ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0W?ooool004oo
oooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Mooooo`00Coooool00ol0003ooooo
ooooo`0>ooooo`03o`000?oooooooooo00;ooooo0ol000000ooooooo0000o`000002o`0000Kooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`2Mooooo`00C_ooool00ol0003ooooooooo
o`0?ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool000001?ooool00ol0003ooooooooo
o`04ooooo`?o00000oooool00ol0003oooooooooo`2Mooooo`00C_ooool00ol0003oooooooooo`0>
ooooo`03o`000?oooooooooo00Cooooo0_l00004ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`2Mooooo`00COooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool2o`0000Kooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`2Nooooo`00COooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo00;ooooo0ol00003ooooo`?o00001_ooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo09kooooo001<ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0:ooooo`;o00000oooool00ol0003oooooooooo`2Nooooo`00C?oo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo09kooooo001<ooooo`03o`000?oooooo
oooo00oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0;ooooo`05o`000?oooooo
ooooooooool00000XOooool004_ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo00_ooooo00Go0000ooooooooooooooooo`00002Qooooo`00Boooool0
0ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool02oooool2
o`0000;ooooo00?o0000ooooooooool0Woooool004_ooooo00?o0000ooooooooool03oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00cooooo00Go0000ooooooooooooooooo`00002Q
ooooo`00B_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool03?ooool01?l0003oooooooooool0002Rooooo`00B_ooool00ol0003oooooooooo`0@oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool03?ooool01?l0003oooooooooool0002R
ooooo`00B_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool03Oooool2o`000003ooooool0003ooooo0:7ooooo0019ooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0=ooooo`04o`000?ooooooooooo`00
0:;ooooo0019ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0=ooooo`04o`000?ooooooooooo`000:;ooooo0019ooooo`03o`000?oooooooooo00oo
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooo00000:?o
oooo0018ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`0=ooooo`?o0000Xoooool004Sooooo00?o0000ooooooooool04?ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00kooooo00?o0000ooooool00000Xoooool004Sooooo00?o0000
ooooooooool04?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00kooooo00?o0000
ooooool00000Xoooool004Oooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00Gooooo0ol00006ooooo`;o0000Y?ooool004Oooooo00?o0000oooooooo
ool04?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool01?ooool3o`000:?ooooo001/ooooo`03o`000?oooooooooo0:[ooooo001/ooooo`03o`000?oo
oooooooo0:[ooooo001Zooooo`?o0000[?ooool00?oooooo6_ooool00?oooooo6_ooool00001\
\>"],
  ImageRangeCache->{{{0, 280.812}, {173.188, 0}} -> {-2.29633, -1.12258, \
0.0198832, 0.0245118}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Combine the plots"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The ",
  StyleBox["PlotRange",
    FontWeight->"Bold"],
  " is extended slightly in the vertical direction so as to not cut off the \
top and bottom rows of line segments that indicate the direction field."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[field, curves, PlotRange \[Rule] {\(-1.1\), 3.1}, 
        Frame \[Rule] True];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .78726 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.399807 0.187442 0.206186 0.187442 [
[.02492 -0.0125 -6.75 -10 ]
[.02492 -0.0125 6.75 0 ]
[.21237 -0.0125 -6.75 -10 ]
[.21237 -0.0125 6.75 0 ]
[.39981 -0.0125 -4 -10 ]
[.39981 -0.0125 4 0 ]
[.58725 -0.0125 -4 -10 ]
[.58725 -0.0125 4 0 ]
[.77469 -0.0125 -4 -10 ]
[.77469 -0.0125 4 0 ]
[.96213 -0.0125 -4 -10 ]
[.96213 -0.0125 4 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01874 -13.5 -5 ]
[-0.0125 .01874 0 5 ]
[-0.0125 .20619 -8 -5 ]
[-0.0125 .20619 0 5 ]
[-0.0125 .39363 -8 -5 ]
[-0.0125 .39363 0 5 ]
[-0.0125 .58107 -8 -5 ]
[-0.0125 .58107 0 5 ]
[-0.0125 .76851 -8 -5 ]
[-0.0125 .76851 0 5 ]
[ 0 0 -0.125 0 ]
[ 0 .78726 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .78726 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02492 0 m
.02492 .00625 L
s
gsave
.02492 -0.0125 -67.75 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.500 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.21237 0 m
.21237 .00625 L
s
gsave
.21237 -0.0125 -67.75 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.500 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.39981 0 m
.39981 .00625 L
s
gsave
.39981 -0.0125 -65 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
1.000 setlinewidth
grestore
.58725 0 m
.58725 .00625 L
s
gsave
.58725 -0.0125 -65 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.77469 0 m
.77469 .00625 L
s
gsave
.77469 -0.0125 -65 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.96213 0 m
.96213 .00625 L
s
gsave
.96213 -0.0125 -65 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.125 Mabswid
.06241 0 m
.06241 .00375 L
s
.0999 0 m
.0999 .00375 L
s
.13739 0 m
.13739 .00375 L
s
.17488 0 m
.17488 .00375 L
s
.24985 0 m
.24985 .00375 L
s
.28734 0 m
.28734 .00375 L
s
.32483 0 m
.32483 .00375 L
s
.36232 0 m
.36232 .00375 L
s
.4373 0 m
.4373 .00375 L
s
.47478 0 m
.47478 .00375 L
s
.51227 0 m
.51227 .00375 L
s
.54976 0 m
.54976 .00375 L
s
.62474 0 m
.62474 .00375 L
s
.66223 0 m
.66223 .00375 L
s
.69971 0 m
.69971 .00375 L
s
.7372 0 m
.7372 .00375 L
s
.81218 0 m
.81218 .00375 L
s
.84967 0 m
.84967 .00375 L
s
.88716 0 m
.88716 .00375 L
s
.92464 0 m
.92464 .00375 L
s
.99962 0 m
.99962 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01874 m
.00625 .01874 L
s
gsave
-0.0125 .01874 -74.5 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.500 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
0 .20619 m
.00625 .20619 L
s
gsave
-0.0125 .20619 -69 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
1.000 setlinewidth
grestore
0 .39363 m
.00625 .39363 L
s
gsave
-0.0125 .39363 -69 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
0 .58107 m
.00625 .58107 L
s
gsave
-0.0125 .58107 -69 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
0 .76851 m
.00625 .76851 L
s
gsave
-0.0125 .76851 -69 -9 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.125 Mabswid
0 .05623 m
.00375 .05623 L
s
0 .09372 m
.00375 .09372 L
s
0 .13121 m
.00375 .13121 L
s
0 .1687 m
.00375 .1687 L
s
0 .24367 m
.00375 .24367 L
s
0 .28116 m
.00375 .28116 L
s
0 .31865 m
.00375 .31865 L
s
0 .35614 m
.00375 .35614 L
s
0 .43112 m
.00375 .43112 L
s
0 .46861 m
.00375 .46861 L
s
0 .50609 m
.00375 .50609 L
s
0 .54358 m
.00375 .54358 L
s
0 .61856 m
.00375 .61856 L
s
0 .65605 m
.00375 .65605 L
s
0 .69354 m
.00375 .69354 L
s
0 .73102 m
.00375 .73102 L
s
.25 Mabswid
0 0 m
0 .78726 L
s
.02492 .78101 m
.02492 .78726 L
s
.21237 .78101 m
.21237 .78726 L
s
.39981 .78101 m
.39981 .78726 L
s
.58725 .78101 m
.58725 .78726 L
s
.77469 .78101 m
.77469 .78726 L
s
.96213 .78101 m
.96213 .78726 L
s
.125 Mabswid
.06241 .78351 m
.06241 .78726 L
s
.0999 .78351 m
.0999 .78726 L
s
.13739 .78351 m
.13739 .78726 L
s
.17488 .78351 m
.17488 .78726 L
s
.24985 .78351 m
.24985 .78726 L
s
.28734 .78351 m
.28734 .78726 L
s
.32483 .78351 m
.32483 .78726 L
s
.36232 .78351 m
.36232 .78726 L
s
.4373 .78351 m
.4373 .78726 L
s
.47478 .78351 m
.47478 .78726 L
s
.51227 .78351 m
.51227 .78726 L
s
.54976 .78351 m
.54976 .78726 L
s
.62474 .78351 m
.62474 .78726 L
s
.66223 .78351 m
.66223 .78726 L
s
.69971 .78351 m
.69971 .78726 L
s
.7372 .78351 m
.7372 .78726 L
s
.81218 .78351 m
.81218 .78726 L
s
.84967 .78351 m
.84967 .78726 L
s
.88716 .78351 m
.88716 .78726 L
s
.92464 .78351 m
.92464 .78726 L
s
.99962 .78351 m
.99962 .78726 L
s
.25 Mabswid
0 .78726 m
1 .78726 L
s
.99375 .01874 m
1 .01874 L
s
.99375 .20619 m
1 .20619 L
s
.99375 .39363 m
1 .39363 L
s
.99375 .58107 m
1 .58107 L
s
.99375 .76851 m
1 .76851 L
s
.125 Mabswid
.99625 .05623 m
1 .05623 L
s
.99625 .09372 m
1 .09372 L
s
.99625 .13121 m
1 .13121 L
s
.99625 .1687 m
1 .1687 L
s
.99625 .24367 m
1 .24367 L
s
.99625 .28116 m
1 .28116 L
s
.99625 .31865 m
1 .31865 L
s
.99625 .35614 m
1 .35614 L
s
.99625 .43112 m
1 .43112 L
s
.99625 .46861 m
1 .46861 L
s
.99625 .50609 m
1 .50609 L
s
.99625 .54358 m
1 .54358 L
s
.99625 .61856 m
1 .61856 L
s
.99625 .65605 m
1 .65605 L
s
.99625 .69354 m
1 .69354 L
s
.99625 .73102 m
1 .73102 L
s
.25 Mabswid
1 0 m
1 .78726 L
s
0 .20619 m
1 .20619 L
s
.39981 0 m
.39981 .78726 L
s
0 0 m
1 0 L
1 .78726 L
0 .78726 L
closepath
clip
newpath
.0005 w
.02435 .0047 m
.02549 .03279 L
s
.02433 .05156 m
.02551 .07965 L
s
.02431 .09842 m
.02553 .12651 L
s
.02429 .14528 m
.02555 .17337 L
s
.02427 .19214 m
.02557 .22023 L
s
.02425 .239 m
.0256 .26709 L
s
.02422 .28587 m
.02562 .31395 L
s
.0242 .33273 m
.02565 .36081 L
s
.02417 .37959 m
.02568 .40767 L
s
.02414 .42645 m
.02571 .45452 L
s
.0241 .47332 m
.02574 .50138 L
s
.02406 .52018 m
.02578 .54824 L
s
.02402 .56704 m
.02582 .5951 L
s
.02398 .6139 m
.02587 .64196 L
s
.02393 .66077 m
.02592 .68881 L
s
.02387 .70763 m
.02597 .73567 L
s
.02381 .7545 m
.02604 .78253 L
s
.07102 .00471 m
.07255 .03278 L
s
.07098 .05157 m
.07258 .07964 L
s
.07095 .09843 m
.07262 .1265 L
s
.07091 .14529 m
.07266 .17336 L
s
.07087 .19216 m
.0727 .22021 L
s
.07082 .23902 m
.07275 .26707 L
s
.07077 .28589 m
.0728 .31393 L
s
.07071 .33275 m
.07286 .36078 L
s
.07064 .37962 m
.07292 .40764 L
s
.07057 .42648 m
.073 .45449 L
s
.07049 .47335 m
.07308 .50135 L
s
.07039 .52022 m
.07317 .5482 L
s
.07028 .56709 m
.07329 .59505 L
s
.07015 .61397 m
.07342 .64189 L
s
.07 .66085 m
.07357 .68874 L
s
.06981 .70773 m
.07376 .73557 L
s
.06958 .75463 m
.07399 .7824 L
s
.11764 .00472 m
.11965 .03277 L
s
.11759 .05159 m
.1197 .07962 L
s
.11752 .09845 m
.11977 .12648 L
s
.11745 .14532 m
.11984 .17333 L
s
.11737 .19219 m
.11992 .22019 L
s
.11728 .23906 m
.12001 .26704 L
s
.11717 .28593 m
.12012 .31389 L
s
.11705 .3328 m
.12024 .36073 L
s
.1169 .37968 m
.12039 .40758 L
s
.11672 .42656 m
.12057 .45441 L
s
.1165 .47346 m
.12079 .50124 L
s
.11623 .52036 m
.12106 .54806 L
s
.11588 .56729 m
.12141 .59485 L
s
.11542 .61425 m
.12187 .64161 L
s
.11477 .66128 m
.12252 .6883 L
s
.11382 .70845 m
.12347 .73486 L
s
.11233 .75595 m
.12496 .78107 L
s
.16423 .00474 m
.16677 .03274 L
s
.16414 .05161 m
.16687 .0796 L
s
.16404 .09848 m
.16697 .12645 L
s
.16391 .14536 m
.1671 .17329 L
s
.16377 .19224 m
.16724 .22014 L
s
.16359 .23912 m
.16742 .26697 L
s
.16337 .28601 m
.16764 .3138 L
s
.1631 .33292 m
.1679 .36062 L
s
.16276 .37984 m
.16825 .40742 L
s
.1623 .4268 m
.16871 .45418 L
s
.16166 .47383 m
.16935 .50087 L
s
.16073 .52099 m
.17028 .54743 L
s
.15927 .56847 m
.17174 .59367 L
s
.15681 .61688 m
.1742 .63898 L
s
.15304 .6683 m
.17797 .68129 L
s
.1518 .72479 m
.17921 .71851 L
s
.15546 .77835 m
.17555 .75868 L
s
.21081 .00477 m
.21392 .03272 L
s
.21067 .05165 m
.21406 .07956 L
s
.2105 .09853 m
.21423 .1264 L
s
.2103 .14542 m
.21443 .17323 L
s
.21005 .19232 m
.21468 .22005 L
s
.20973 .23924 m
.215 .26685 L
s
.2093 .28619 m
.21543 .31363 L
s
.20873 .33319 m
.216 .36035 L
s
.20789 .3803 m
.21684 .40696 L
s
.20662 .42766 m
.21811 .45332 L
s
.2045 .4757 m
.22023 .499 L
s
.20102 .52591 m
.22371 .54251 L
s
.19831 .58133 m
.22642 .58081 L
s
.20122 .6365 m
.22351 .61937 L
s
.20463 .68653 m
.2201 .66305 L
s
.20669 .73452 m
.21804 .70879 L
s
.20794 .78186 m
.21679 .75517 L
s
.25739 .00481 m
.26106 .03268 L
s
.25719 .05169 m
.26126 .07951 L
s
.25694 .09859 m
.26151 .12634 L
s
.25663 .14551 m
.26182 .17314 L
s
.25623 .19245 m
.26222 .21992 L
s
.25567 .23944 m
.26278 .26665 L
s
.25488 .28654 m
.26357 .31328 L
s
.25368 .33385 m
.26477 .35969 L
s
.25171 .38175 m
.26674 .40551 L
s
.24841 .43151 m
.27004 .44947 L
s
.24521 .48623 m
.27324 .48847 L
s
.24755 .54203 m
.27091 .52639 L
s
.25113 .59256 m
.26732 .56958 L
s
.25334 .6407 m
.26511 .61516 L
s
.25467 .68809 m
.26378 .66149 L
s
.25553 .73522 m
.26292 .70809 L
s
.25612 .78222 m
.26233 .7548 L
s
.30399 .00484 m
.30819 .03264 L
s
.30372 .05175 m
.30845 .07946 L
s
.30339 .09867 m
.30878 .12626 L
s
.30295 .14562 m
.30922 .17303 L
s
.30234 .19264 m
.30983 .21974 L
s
.30146 .23977 m
.31072 .26632 L
s
.30008 .2872 m
.31209 .31262 L
s
.29779 .33542 m
.31439 .35811 L
s
.29412 .38625 m
.31805 .40101 L
s
.29215 .44234 m
.32002 .43864 L
s
.29555 .49665 m
.31662 .47804 L
s
.29874 .5462 m
.31343 .52222 L
s
.30065 .59403 m
.31153 .56811 L
s
.30181 .64132 m
.31036 .61454 L
s
.30258 .68841 m
.30959 .66118 L
s
.30312 .73539 m
.30905 .70791 L
s
.30352 .78233 m
.30865 .75469 L
s
.35062 .00488 m
.35527 .03261 L
s
.35029 .0518 m
.3556 .07941 L
s
.34987 .09875 m
.35603 .12618 L
s
.34928 .14575 m
.35661 .1729 L
s
.34844 .19287 m
.35745 .2195 L
s
.34714 .24024 m
.35875 .26585 L
s
.34498 .28832 m
.36091 .31149 L
s
.34146 .33867 m
.36444 .35487 L
s
.3389 .39426 m
.36699 .393 L
s
.34194 .44924 m
.36395 .43174 L
s
.34531 .49915 m
.36059 .47555 L
s
.34733 .5471 m
.35856 .52132 L
s
.34856 .59443 m
.35733 .56771 L
s
.34936 .64152 m
.35653 .61434 L
s
.34993 .68852 m
.35597 .66106 L
s
.35034 .73547 m
.35556 .70784 L
s
.35065 .78238 m
.35524 .75464 L
s
.39729 .00491 m
.40232 .03258 L
s
.39691 .05185 m
.4027 .07936 L
s
.3964 .09883 m
.40322 .1261 L
s
.39567 .14589 m
.40394 .17276 L
s
.39459 .19313 m
.40503 .21924 L
s
.39283 .24084 m
.40678 .26525 L
s
.38987 .28997 m
.40975 .30985 L
s
.38617 .34336 m
.41345 .35018 L
s
.38723 .39992 m
.41238 .38734 L
s
.39103 .45147 m
.40859 .42951 L
s
.39352 .49992 m
.40609 .47478 L
s
.395 .54742 m
.40461 .521 L
s
.39595 .59459 m
.40367 .56755 L
s
.39659 .64162 m
.40303 .61425 L
s
.39705 .68858 m
.40256 .66101 L
s
.3974 .7355 m
.40222 .7078 L
s
.39767 .78241 m
.40194 .75462 L
s
.44401 .00494 m
.44933 .03255 L
s
.44358 .05189 m
.44976 .07932 L
s
.44299 .0989 m
.45035 .12603 L
s
.44214 .14602 m
.4512 .17263 L
s
.44082 .1934 m
.45251 .21897 L
s
.43864 .24151 m
.4547 .26459 L
s
.43508 .29194 m
.45825 .30787 L
s
.43264 .34765 m
.4607 .34589 L
s
.43576 .40249 m
.45758 .38476 L
s
.43909 .45233 m
.45424 .42865 L
s
.44109 .50025 m
.45225 .47445 L
s
.4423 .54757 m
.45103 .52085 L
s
.4431 .59467 m
.45023 .56747 L
s
.44366 .64166 m
.44968 .6142 L
s
.44407 .68861 m
.44927 .66098 L
s
.44438 .73552 m
.44896 .70778 L
s
.44463 .78242 m
.44871 .7546 L
s
.49076 .00496 m
.4963 .03253 L
s
.49029 .05192 m
.49677 .07928 L
s
.48964 .09896 m
.49742 .12597 L
s
.48868 .14613 m
.49838 .17252 L
s
.48717 .19365 m
.49989 .21872 L
s
.48463 .24217 m
.50243 .26393 L
s
.48082 .2939 m
.50624 .30591 L
s
.47998 .35053 m
.50707 .34301 L
s
.48372 .4037 m
.50333 .38355 L
s
.48664 .45274 m
.50042 .42824 L
s
.48836 .50042 m
.4987 .47428 L
s
.48943 .54766 m
.49763 .52076 L
s
.49014 .59471 m
.49692 .56743 L
s
.49065 .64169 m
.49641 .61417 L
s
.49103 .68862 m
.49603 .66096 L
s
.49132 .73553 m
.49574 .70777 L
s
.49155 .78243 m
.49551 .75459 L
s
.53754 .00498 m
.54324 .03251 L
s
.53704 .05195 m
.54374 .07926 L
s
.53634 .099 m
.54444 .12593 L
s
.5353 .14622 m
.54548 .17243 L
s
.53363 .19386 m
.54715 .21851 L
s
.53081 .24276 m
.54997 .26334 L
s
.52702 .29557 m
.55376 .30425 L
s
.52745 .35227 m
.55333 .34127 L
s
.53128 .40434 m
.5495 .38292 L
s
.53391 .45296 m
.54687 .42801 L
s
.53547 .50052 m
.54531 .47418 L
s
.53645 .5477 m
.54433 .52071 L
s
.53711 .59474 m
.54366 .5674 L
s
.53759 .64171 m
.54319 .61415 L
s
.53795 .68864 m
.54283 .66095 L
s
.53823 .73554 m
.54255 .70776 L
s
.53845 .78244 m
.54233 .75459 L
s
.58434 .00499 m
.59016 .0325 L
s
.58382 .05197 m
.59068 .07924 L
s
.58308 .09904 m
.59141 .12589 L
s
.58198 .14629 m
.59252 .17236 L
s
.58019 .19403 m
.59431 .21835 L
s
.57717 .24324 m
.59732 .26285 L
s
.57353 .29685 m
.60097 .30297 L
s
.57481 .35332 m
.59969 .34021 L
s
.57858 .4047 m
.59592 .38256 L
s
.58103 .4531 m
.59347 .42788 L
s
.58249 .50058 m
.59201 .47412 L
s
.58341 .54773 m
.59108 .52068 L
s
.58405 .59476 m
.59045 .56738 L
s
.58451 .64172 m
.58999 .61414 L
s
.58485 .68864 m
.58965 .66094 L
s
.58512 .73555 m
.58938 .70776 L
s
.58534 .78244 m
.58916 .75459 L
s
.63116 .005 m
.63706 .03249 L
s
.63062 .05199 m
.6376 .07922 L
s
.62986 .09906 m
.63836 .12587 L
s
.62871 .14635 m
.63951 .17231 L
s
.62683 .19416 m
.64139 .21822 L
s
.62368 .24362 m
.64454 .26247 L
s
.62021 .29778 m
.64801 .30204 L
s
.62204 .35397 m
.64618 .33956 L
s
.62573 .40491 m
.64249 .38234 L
s
.62806 .45318 m
.64016 .4278 L
s
.62945 .50061 m
.63877 .47409 L
s
.63034 .54775 m
.63788 .52067 L
s
.63096 .59477 m
.63726 .56737 L
s
.6314 .64173 m
.63682 .61414 L
s
.63174 .68865 m
.63648 .66093 L
s
.632 .73555 m
.63622 .70775 L
s
.63221 .78244 m
.63601 .75458 L
s
.67799 .00501 m
.68395 .03248 L
s
.67744 .052 m
.6845 .07921 L
s
.67666 .09908 m
.68528 .12585 L
s
.67548 .14639 m
.68646 .17227 L
s
.67354 .19425 m
.6884 .21812 L
s
.67029 .24391 m
.69165 .26218 L
s
.66699 .29843 m
.69495 .30138 L
s
.66915 .35438 m
.69279 .33915 L
s
.67278 .40505 m
.68916 .3822 L
s
.67503 .45323 m
.68691 .42775 L
s
.67638 .50064 m
.68556 .47406 L
s
.67725 .54777 m
.68469 .52065 L
s
.67785 .59478 m
.68409 .56736 L
s
.67829 .64173 m
.68365 .61413 L
s
.67862 .68865 m
.68332 .66093 L
s
.67888 .73555 m
.68306 .70775 L
s
.67909 .78244 m
.68285 .75458 L
s
.72483 .00501 m
.73083 .03248 L
s
.72427 .052 m
.73139 .07921 L
s
.72348 .0991 m
.73218 .12583 L
s
.72227 .14641 m
.73339 .17224 L
s
.72029 .19432 m
.73537 .21805 L
s
.71697 .24412 m
.73869 .26198 L
s
.71381 .29889 m
.74185 .30092 L
s
.71619 .35465 m
.73947 .33888 L
s
.71976 .40514 m
.7359 .38211 L
s
.72196 .45326 m
.7337 .42771 L
s
.72329 .50065 m
.73237 .47405 L
s
.72414 .54778 m
.73152 .52064 L
s
.72473 .59478 m
.73093 .56736 L
s
.72516 .64173 m
.7305 .61413 L
s
.72549 .68865 m
.73017 .66093 L
s
.72575 .73555 m
.72991 .70775 L
s
.72595 .78244 m
.72971 .75458 L
s
.77167 .00501 m
.77771 .03247 L
s
.77111 .05201 m
.77827 .0792 L
s
.77031 .09911 m
.77907 .12582 L
s
.76909 .14643 m
.7803 .17222 L
s
.76707 .19437 m
.78231 .218 L
s
.76371 .24427 m
.78567 .26183 L
s
.76065 .29921 m
.78873 .30061 L
s
.76318 .35483 m
.78621 .3387 L
s
.76671 .4052 m
.78267 .38205 L
s
.76887 .45329 m
.78051 .42769 L
s
.77018 .50066 m
.7792 .47404 L
s
.77102 .54778 m
.77836 .52064 L
s
.77161 .59479 m
.77777 .56735 L
s
.77204 .64174 m
.77735 .61413 L
s
.77236 .68866 m
.77702 .66093 L
s
.77262 .73556 m
.77677 .70775 L
s
.77282 .78245 m
.77656 .75458 L
s
.81852 .00502 m
.82458 .03247 L
s
.81796 .05201 m
.82514 .0792 L
s
.81715 .09911 m
.82595 .12582 L
s
.81591 .14645 m
.82719 .1722 L
s
.81388 .19441 m
.82923 .21796 L
s
.81049 .24437 m
.83261 .26172 L
s
.8075 .29943 m
.8356 .30039 L
s
.81012 .35495 m
.83298 .33859 L
s
.81363 .40524 m
.82947 .38202 L
s
.81577 .4533 m
.82733 .42768 L
s
.81706 .50067 m
.82604 .47403 L
s
.8179 .54778 m
.82521 .52063 L
s
.81848 .59479 m
.82462 .56735 L
s
.8189 .64174 m
.8242 .61412 L
s
.81923 .68866 m
.82388 .66093 L
s
.81948 .73556 m
.82362 .70775 L
s
.81969 .78245 m
.82342 .75458 L
s
.86538 .00502 m
.87145 .03247 L
s
.86481 .05202 m
.87201 .07919 L
s
.864 .09912 m
.87283 .12581 L
s
.86275 .14646 m
.87407 .17219 L
s
.8607 .19443 m
.87613 .21794 L
s
.85729 .24445 m
.87953 .26165 L
s
.85436 .29958 m
.88247 .30024 L
s
.85704 .35503 m
.87979 .33851 L
s
.86053 .40527 m
.8763 .38199 L
s
.86265 .45331 m
.87417 .42766 L
s
.86394 .50068 m
.87289 .47402 L
s
.86477 .54779 m
.87206 .52063 L
s
.86535 .59479 m
.87148 .56735 L
s
.86577 .64174 m
.87105 .61412 L
s
.86609 .68866 m
.87073 .66093 L
s
.86634 .73556 m
.87048 .70775 L
s
.86655 .78245 m
.87028 .75458 L
s
.91223 .00502 m
.91831 .03247 L
s
.91166 .05202 m
.91888 .07919 L
s
.91085 .09912 m
.9197 .12581 L
s
.9096 .14646 m
.92095 .17219 L
s
.90753 .19445 m
.92301 .21792 L
s
.90411 .2445 m
.92643 .2616 L
s
.90122 .29968 m
.92933 .30013 L
s
.90394 .35508 m
.92661 .33845 L
s
.90742 .40529 m
.92313 .38197 L
s
.90953 .45332 m
.92102 .42766 L
s
.91081 .50068 m
.91974 .47402 L
s
.91164 .54779 m
.91891 .52063 L
s
.91221 .59479 m
.91833 .56735 L
s
.91263 .64174 m
.91791 .61412 L
s
.91296 .68866 m
.91759 .66093 L
s
.91321 .73556 m
.91734 .70775 L
s
.91341 .78245 m
.91713 .75458 L
s
.95909 .00502 m
.96518 .03247 L
s
.95852 .05202 m
.96575 .07919 L
s
.9577 .09912 m
.96656 .12581 L
s
.95645 .14647 m
.96782 .17218 L
s
.95437 .19446 m
.96989 .21791 L
s
.95095 .24453 m
.97332 .26156 L
s
.94808 .29975 m
.97619 .30006 L
s
.95083 .35512 m
.97344 .33841 L
s
.95429 .4053 m
.96997 .38196 L
s
.9564 .45332 m
.96787 .42765 L
s
.95767 .50068 m
.96659 .47402 L
s
.9585 .54779 m
.96577 .52063 L
s
.95908 .59479 m
.96519 .56735 L
s
.9595 .64174 m
.96477 .61412 L
s
.95982 .68866 m
.96445 .66093 L
s
.96007 .73556 m
.9642 .70775 L
s
.96027 .78245 m
.96399 .75458 L
s
.5 Mabswid
.28166 0 m
.29121 .06498 L
.30123 .12094 L
.31066 .16457 L
.32072 .20288 L
.33881 .25472 L
.34893 .27609 L
.35988 .29435 L
.37022 .30777 L
.37973 .31741 L
.38931 .32495 L
.39826 .33035 L
.40807 .33476 L
.41357 .33665 L
.41859 .33804 L
.42332 .33911 L
.42835 .34 L
.43264 .34058 L
.43737 .34105 L
.44002 .34124 L
.44244 .34138 L
.44371 .34143 L
.4451 .34148 L
.44581 .3415 L
.44656 .34152 L
.44726 .34153 L
.44791 .34154 L
.44919 .34156 L
.44986 .34156 L
.45057 .34156 L
.45177 .34156 L
.45245 .34155 L
.45309 .34154 L
.45428 .34152 L
.45536 .3415 L
.4578 .34143 L
.46027 .34132 L
.46251 .34121 L
.46751 .34088 L
.47652 .34009 L
.49693 .33755 L
.53641 .33126 L
.5744 .32508 L
.6148 .31927 L
.65371 .31468 L
.69113 .31117 L
.73096 .30827 L
.7693 .30615 L
.81005 .30446 L
.84931 .30326 L
Mistroke
.88708 .3024 L
.92727 .30172 L
.96213 .30128 L
Mfstroke
.22081 0 m
.22229 .01419 L
.2325 .0947 L
.24221 .15721 L
.26044 .24506 L
.26988 .27845 L
.27993 .30685 L
.28936 .32785 L
.29803 .34315 L
.30815 .35692 L
.31337 .36256 L
.3191 .36776 L
.32875 .37445 L
.33402 .37716 L
.33895 .37916 L
.34387 .38071 L
.34647 .38136 L
.34923 .38193 L
.35164 .38234 L
.35429 .38269 L
.35545 .38281 L
.35671 .38293 L
.35788 .38301 L
.35897 .38308 L
.36005 .38313 L
.36119 .38318 L
.36246 .3832 L
.36361 .38321 L
.36482 .38321 L
.3655 .3832 L
.36613 .38319 L
.36728 .38315 L
.3685 .3831 L
.37065 .38298 L
.37266 .38283 L
.37724 .38236 L
.38214 .38167 L
.38748 .38074 L
.3972 .37865 L
.41544 .37369 L
.45549 .36072 L
.49405 .34832 L
.53502 .33688 L
.5745 .32792 L
.61249 .32113 L
.65289 .31558 L
.6918 .31155 L
.72922 .30862 L
.76905 .30629 L
.80739 .30463 L
Mistroke
.84814 .30333 L
.8874 .30241 L
.92517 .30176 L
.96213 .30129 L
Mfstroke
.13265 0 m
.14278 .13062 L
.15207 .21901 L
.1623 .29695 L
.17298 .36032 L
.18299 .40591 L
.19321 .44116 L
.20292 .46599 L
.21163 .48231 L
.21657 .48943 L
.22115 .49482 L
.22614 .4995 L
.22877 .5015 L
.23155 .50329 L
.23398 .5046 L
.23665 .50579 L
.2391 .50665 L
.24134 .50726 L
.24247 .50751 L
.24369 .50773 L
.24475 .50788 L
.24591 .50801 L
.24715 .50811 L
.24782 .50814 L
.24846 .50817 L
.24959 .50818 L
.25081 .50815 L
.25189 .50809 L
.25306 .508 L
.25429 .50786 L
.25543 .50771 L
.25747 .50735 L
.25965 .50687 L
.2649 .50533 L
.26973 .50346 L
.28066 .49795 L
.30049 .48469 L
.33927 .45337 L
.37655 .42323 L
.41625 .39506 L
.45445 .37279 L
.49507 .35413 L
.5342 .34035 L
.57184 .33026 L
.61189 .32217 L
.65044 .31638 L
.69141 .31185 L
.73089 .30865 L
.76888 .30637 L
.80928 .3046 L
Mistroke
.84819 .30335 L
.88561 .30246 L
.92544 .30177 L
.96213 .30129 L
Mfstroke
.23083 .78726 m
.25903 .68541 L
.29982 .57806 L
.33911 .50301 L
.37691 .44999 L
.41713 .40869 L
.45585 .3797 L
.49309 .35914 L
.53273 .34304 L
.57089 .33169 L
.61145 .32288 L
.65053 .31671 L
.68812 .31235 L
.72811 .30894 L
.76662 .30654 L
.80754 .30469 L
.84697 .3034 L
.8849 .30248 L
.92525 .30177 L
.96213 .3013 L
s
.3041 .78726 m
.32203 .6955 L
.3418 .61728 L
.37938 .51204 L
.39874 .47361 L
.41938 .44101 L
.43903 .41621 L
.4603 .39471 L
.49973 .36555 L
.51935 .35483 L
.54008 .34554 L
.57744 .3328 L
.59664 .32778 L
.61722 .32329 L
.65793 .3165 L
.69714 .31188 L
.73485 .30868 L
.77499 .30623 L
.81363 .30453 L
.85078 .30333 L
.89034 .30239 L
.92841 .30174 L
.96213 .3013 L
s
.33349 .78726 m
.3418 .73587 L
.36129 .64361 L
.37938 .57703 L
.39958 .51917 L
.41789 .47821 L
.43842 .44217 L
.45731 .41611 L
.49525 .37847 L
.51378 .36523 L
.53411 .35349 L
.55492 .34385 L
.57389 .33671 L
.61218 .32588 L
.63096 .32188 L
.65139 .31827 L
.67047 .31546 L
.69152 .31289 L
.73016 .30927 L
.76973 .30663 L
.8078 .30482 L
.84828 .30343 L
.88727 .30247 L
.92478 .3018 L
.96213 .30131 L
s
.40187 .78726 m
.41789 .68873 L
.43683 .60012 L
.45731 .52812 L
.47694 .47641 L
.49766 .4353 L
.51699 .40629 L
.53503 .3853 L
.55506 .36723 L
.57332 .3544 L
.5921 .344 L
.61253 .33514 L
.63199 .32852 L
.65266 .32298 L
.68981 .31579 L
.70885 .31311 L
.72938 .31077 L
.74871 .30897 L
.76986 .30738 L
.80885 .30518 L
.82815 .30436 L
.84877 .30363 L
.86836 .30305 L
.8896 .30254 L
.92895 .3018 L
.96213 .30134 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{256.875, 202.25},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000400000bR000`400?l00000o`00003oooooool1
ooooo`00ooooool1ooooo`00ooooool1ooooo`00ooooool1ooooo`006?ooool3o`0002[ooooo00?o
0000ooooooooool09_ooool3o`0002[ooooo00?o0000ooooooooool0:_ooool3o`0002Wooooo0ol0
0009ooooo`004oooool4o`000003ooooool0003ooooo02Gooooo1?l00002ooooo`03o`000?oooooo
oooo02Kooooo00Co0000oooooooooooo0000:Oooool00ol0003oooooooooo`0Zooooo`03o`000?oo
oooooooo02_ooooo00?o0000ooooooooool01oooool001Wooooo00?o0000ooooooooool0:Oooool0
0ol0003oooooooooo`0Vooooo`04o`000?ooooooooooo`0002Wooooo00?o0000ooooooooool0:ooo
ool00ol0003oooooooooo`0Zooooo`03o`000?oooooooooo00Oooooo000Iooooo`03o`000?oooooo
oooo02Wooooo00?o0000ooooooooool09_ooool01?l0003oooooooooool0000Yooooo`03o`000?oo
oooooooo02_ooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`07ooooo`005oooool3
o`0002_ooooo00?o0000ooooooooool09_ooool3o`0002[ooooo00?o0000ooooooooool0:Oooool3
o`0002[ooooo0ol00009ooooo`00ooooool1ooooo`00ooooool1ooooo`00ooooool1ooooo`00oooo
ool1ooooo`004?ooooo`o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooool000001_ooool01Ol0003ooooooooooooooooo000000?ooooo0_l00006
ooooo`03o`000?oooooo000000Sooooo00?o0000ooooool000001_ooool00ol0003oooooo`000005
ooooo`;o00000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00Co0000
oooooooooooo00001oooool2o`0000Sooooo0_l00007ooooo`04o`000?ooooooooooo`0000Gooooo
00?o0000ooooooooool00oooool00ol0003oooooo`000008ooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooool000001_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000oooooooo
ool00oooool01?l0003oooooooooool00007ooooo`;o00002?ooool00ol0003oooooo`000006oooo
o`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`03ooooo`04o`000?oooooo
ooooo`0000Oooooo0_l00008ooooo`7o0000000@ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`05o`000?ooooooooooooooool000001ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooo000000Sooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool2o`0000Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool2o`0000[ooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo0_l00008ooooo`7o0000000@
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`05o`000?ooooooooooooooool000001oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooo000000Sooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool2o`0000Wooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo0Ol0000000Sooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool01Ol0003ooooooooooooooooo000000Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooo`000008ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo0_l0000:ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`06ooooo`7o00000003
ooooo`Co000000?oooooo`000?ooool01_ooool3o`0000?ooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooo`000009ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01?oo
ool3o`0000002?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000Oooooo00?o
0000ooooooooool02?ooool00ol0003oooooo`000009ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool01_ooool1o`0000002?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`04o`000?oooooo
ooooo`0000Oooooo00?o0000ooooooooool02?ooool00ol0003oooooo`000009ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool01Oooool1o`0000002?ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08
ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool02?ooool01?l0003ooooooooo
ool00008ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01Oooool1o`0000004?oo
ool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo08cooooo0Ol00000013ooooo00?o0000
ooooooooool07_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool06?ooool00ol0003oooooooooo`2<ooooo`7o0000000@ooooo`03o`000?oooooooooo
01kooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
01Sooooo00?o0000ooooooooool0S?ooool1o`0000004?ooool00ol0003oooooooooo`0Nooooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Hooooo`03
o`000?oooooooooo08cooooo0Ol00000013ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Sooooo00Co0000oooooooooooo00001oooool00ol0003o
ooooooooo`05ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool02?ooool2o`00
00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Oooooo0Ol00000013ooooo0_l00004ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool02?ooool01Ol0003ooooooooooooooooo000000Kooooo00?o0000ooooooooool01Oooool01?l0
003oooooooooool0000:ooooo`03o`000?oooooooooo00Sooooo0_l00009ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06ooooo`;o0000000@oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`08oooo
o`05o`000?ooooooooooooooool000001_ooool00ol0003oooooooooo`05ooooo`04o`000?oooooo
ooooo`0000[ooooo00?o0000ooooooooool02?ooool2o`0000[ooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0Ol00000013ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Sooooo00Go0000
ooooooooooooooooo`000006ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo0000
2_ooool00ol0003oooooooooo`08ooooo`;o00002_ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01_ooool1o`0000004?ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool01Ol0003ooooooooo
oooooooo000000Kooooo00?o0000ooooooooool02?ooool01Ol0003ooooooooooooooooo000000Oo
oooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo000000[ooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`06ooooo`7o0000000@ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`05o`000?oooooooooooooo
ool000001_ooool00ol0003oooooooooo`08ooooo`05o`000?ooooooooooooooool000001oooool0
0ol0003oooooooooo`04ooooo`05o`000?ooooooooooooooool000002_ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Gooooo0Ol00000013ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00Go0000ooooooooooooooooo`00
0006ooooo`03o`000?oooooooooo00Sooooo00Go0000ooooooooooooooooo`000007ooooo`03o`00
0?oooooooooo00Cooooo00Go0000ooooooooooooooooo`00000:ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool01Oooool1o`0000004?ooool00ol0003oooooooooo`0Nooooo`03o`00
0?oooooooooo01?ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Fooooo`03o`00
0?oooooooooo08cooooo0Ol00000013ooooo00?o0000ooooooooool07_ooool00ol0003ooooooooo
o`0Dooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool05_ooool00ol0003ooooooooo
o`2<ooooo`7o0000000@ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool05?ooool0
0ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool0S?ooool1
o`0000004?ooool2o`0001oooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0<oooo
o`03o`000?oooooooooo01Kooooo00?o0000ooooooooool0Roooool2o`0000004?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01_ooool00ol0003o
ooooo`00000:ooooo`03o`000?oooooooooo00Sooooo0_l00009ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`7o0000000@ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooo000000[ooooo00?o0000ooooooooool02?ooool2o`0000Wooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo0Ol00000013ooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooool000002_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0Ol0
0000013ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00Oooooo0_l0000:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool1
o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool01_ooool00ol0003oooooo`00000:ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01_ooool1o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool01_ooool00ol0003oooooo`00000:ooooo`03o`000?oooooooooo00So
oooo0_l0000:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`05ooooo`7o0000000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo000000[ooooo00?o0000ooooooooool0
2?ooool2o`0000[ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Gooooo0Ol00000013ooooo00?o0000ooooooooool07oooool00ol0003ooooooooo
o`0Dooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool05Oooool00ol0003ooooooooo
o`2<ooooo`7o0000000@ooooo`;o00008?ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooo
oooo00gooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`2;ooooo`;o0000000@oooo
o`03o`000?oooooooooo01oooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0=oooo
o`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0S?ooool1o`0000004?ooool00ol0003o
ooooooooo`0Oooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool03Oooool00ol0003o
ooooooooo`0Dooooo`03o`000?oooooooooo08cooooo0Ol00000013ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1?ooool01Ol0003ooooooooooooooooo000000_ooooo00?o0000ooooooooool01?ooool01Ol0003o
oooooooooooooooo000000[ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`;o00002Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool1o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`04ooooo`05o`000?oooooooooooooo
ool000002oooool00ol0003oooooooooo`04ooooo`05o`000?ooooooooooooooool000002_ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo0_l00009ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`7o0000000@oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Cooooo00Go0000ooooooooooooooooo`00000;ooooo`03o`000?oooooo
oooo00Cooooo00Go0000ooooooooooooooooo`00000:ooooo`;o00002Oooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Oooooo0Ol00000013ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01?ooool0
1Ol0003ooooooooooooooooo000000_ooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooo
oooooooo000000[ooooo0_l00009ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool1o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool01_ooool1o`0000004?ooool2o`0000Cooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool2
o`0000[ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Gooooo0_l00000013ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`;o00002_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01Oooool1o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`04ooooo`05o`000?oooooooooooooo
ool000002oooool00ol0003oooooooooo`04ooooo`05o`000?ooooooooooooooool000002oooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo08cooooo0Ol00000013ooooo00?o0000oooo
ooooool08Oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00gooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`2<ooooo`7o0000000@ooooo`03o`000?oooooooooo027o
oooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool0S?ooool1o`0000004?ooool00ol0003oooooooooo`0Qooooo`03o`00
0?oooooooooo01Cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo08cooooo0Ol00000013ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01Oooool01?l0003ooooooooo
ool0000:ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooool000002_ooool01Ol0003ooooo
oooooooooooo000000Kooooo00?o0000ooooooooool02?ooool00ol0003oooooo`000009ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`1/ooooo`7o
0000000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo00002_ooool00ol0003o
ooooooooo`07ooooo`;o00002_ooool01Ol0003ooooooooooooooooo000000Kooooo00?o0000oooo
ooooool02?ooool00ol0003oooooo`000009ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`7o00000007ooooo`?o00001_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`05ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool01oooool2o`00
00[ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Sooooo0_l0000:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`7o00000007ooooo`04o`000?ooooooooooo`0000Goooool?l0000000Oo
oooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`05ooooo`04o`000?oooooooooo
o`0000[ooooo00?o0000ooooooooool01_ooool00ol0003oooooo`00000:ooooo`05o`000?oooooo
ooooooooool000001oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0Ol0
000000Oooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`05ooooo`04o`000?oo
ooooooooo`0000[ooooo00?o0000ooooooooool01_ooool00ol0003oooooo`00000:ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo00Gooooo0Ol0000000Oooooo0ol00006ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Gooooo00Co
0000oooooooooooo00002oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo000000[ooooo
00Go0000ooooooooooooooooo`000006ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000oooooooo
ool01?ooool1o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0000_o
oooo00?o0000ooooooooool01_ooool00ol0003oooooo`00000:ooooo`05o`000?oooooooooooooo
ool000001oooool00ol0003oooooooooo`07ooooo`;o0000SOooool1o`0000004?ooool00ol0003o
ooooooooo`0Rooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool03oooool00ol0003o
ooooooooo`0>ooooo`03o`000?oooooooooo08cooooo0Ol00000013ooooo00?o0000ooooooooool0
8_ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0
3_ooool00ol0003oooooooooo`2<ooooo`7o0000000@ooooo`03o`000?oooooooooo02;ooooo00?o
0000ooooooooool05Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o
0000ooooooooool0S?ooool1o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
000000[ooooo00?o0000ooooooooool02?ooool2o`0000Wooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`0=ooooo`03o`000?oooooooooo08cooooo0Ol00000013ooooo0_l00004oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07oooo
o`;o00002_ooool00ol0003oooooooooo`08ooooo`;o00002Oooool00ol0003oooooooooo`05oooo
o`04o`000?ooooooooooo`0000[ooooo00?o0000ooooool000002?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool2o`0000[ooooo00?o0000
ooooooooool0=?ooool2o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`;o00002_ooool00ol0
003oooooooooo`08ooooo`;o00002Oooool00ol0003oooooooooo`05ooooo`04o`000?oooooooooo
o`0000[ooooo00?o0000ooooool000002?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Oooooo0_l00009ooooo`;o00002Oooool2o`0000Wooooo0_l0000:ooooo`7o0000000@oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Oooooo0_l0000;ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0000[ooooo0_l00009
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07
ooooo`7o0000000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooool000002_ooool00ol0
003oooooooooo`08ooooo`;o00002Oooool00ol0003oooooooooo`05ooooo`04o`000?oooooooooo
o`0000_ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01_ooool1o`0000004?ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06oooo
o`03o`000?oooooo000000[ooooo00?o0000ooooooooool02?ooool2o`0000Wooooo00?o0000oooo
ooooool01Oooool01Ol0003ooooooooooooooooo000000[ooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01Oooool1
o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooo000000_ooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Gooooo00Co0000oooo
oooooooo00002_ooool2o`0000_ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Cooooo0Ol00000013ooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool00ol0
003oooooo`00000;ooooo`03o`000?oooooooooo00Sooooo0_l00009ooooo`03o`000?oooooooooo
00Kooooo00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`2<ooooo`7o0000000@oooo
o`03o`000?oooooooooo02?ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0@oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0S?ooool1o`0000004?ooool00ol0003o
ooooooooo`0Sooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`09ooooo`03o`000?oooooooooo08cooooo0Ol00000013ooooo0_l0000Uooooo`03o`00
0?oooooooooo01Oooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo08_ooooo0_l00000013ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo08cooooo0Ol00000013ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooool000001oooool0
1?l0003oooooooooool0002>ooooo`7o0000000@ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000Oooooo00?o
0000ooooool000001oooool2o`0000Wooooo0_l0001jooooo`7o0000000@ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`05o`000?oooooo
ooooooooool000001_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000000Sooooo0_l0
0009ooooo`03o`000?oooooooooo00Sooooo0_l00007ooooo`?o00002?ooool5o`0000Kooooo1Ol0
0006ooooo`Go0000Boooool1o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`;o00002_ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000Sooooo00?o0000ooooooooool02?oo
ool2o`0000[ooooo0_l00008ooooo`?o00002_ooool3o`0000Sooooo0ol00008ooooo`?o00001?oo
ool7o`0000Cooooo1ol00004ooooo`So00000ooooolNo`0000Gooooo0Ol00000013ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01oooool2o`0000[ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02?ooool01?l0003oooooooooool0
0007ooooo`;o00002oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool0;?oooolMo`0001oooooo0Ol00000013ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00Go0000ooooooooooooooooo`00
0006ooooo`03o`000?oooooooooo00Sooooo00Go0000ooooooooooooooooo`000006ooooo`03o`00
0?oooooo000000_ooooo00?o0000ooooooooool0<?oooolLo`0003;ooooo0Ol00000013ooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Sooooo00Go
0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo03Gooooo5?l00013ooooo`7o0000
000@ooooo`;o00009_ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo01Cooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`0^oooooaKo0000Aoooool2o`0000004?ooool0
0ol0003oooooooooo`0Uooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool05Oooool0
1Ol0003ooooooooooooooooo000002_ooooo3_l000000ooooooo0000o`000004o`0004kooooo0Ol0
0000013ooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooo
oooo01Gooooo0_l000000ooooooo0000ooooo`0Soooooa3o00000oooool3o`0005Cooooo0Ol00000
013ooooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo
01Oooooo0ol0000Loooooa?o00001?ooool3o`0005Oooooo0Ol00000013ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooo`000008ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01_ooool2o`0001Sooooo00?o0000ooooool000005_ooool5o`0000Cooooo1Ol00002ooooo`Go
00000oooool4o`0005[ooooo0Ol00000013ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooo
o`000008ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool2o`0000[ooooo
0_l0000<ooooo`03o`000?oooooooooo00Ko00002?ooool8o`0000Gooooo1_l00002ooooo`Go0000
0oooool3o`0000Sooooo0_l0000:ooooo`;o00002Oooool2o`0000Wooooo0_l00009ooooo`;o0000
2Oooool2o`0000Wooooo0_l0000:ooooo`;o00001Oooool1o`0000004?ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooo000000Wooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`06ooooo`;o00002oooool00ol0003oooooooooo`05ooooo`?o000000?oooooo`000?ooool01ooo
ool8o`0000Oooooo2Ol00002ooooo`Co00001Oooool3o`0000Wooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`05ooooo`7o0000000@ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooool000002Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo0_l0000;
ooooo`03o`000?oooooooooo00Oooooo0ol00006ooooo`Oo00001_ooool4o`000003ooooool0003o
000000;o00000_ooool4o`0000Kooooo0ol0000:ooooo`03o`000?oooooooooo00Sooooo0_l00009
ooooo`;o00002Oooool2o`0000[ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo0_l00008ooooo`7o0000000@ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooool000002?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`07ooooo`04o`000?oooooo0000
o`0000kooooo0ol00002ooooo`Go000000Koooooo`000?l0003o0000ooooool00007ooooo`;o0000
2oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo0Ol00000013ooooo0_l0
0004ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooo000000Wooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`0<ooooo`?o00000oooool4o`0000;ooooo0_l00002ooooo`;o00001oooool2o`0000_ooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`;o0000000@ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooool000002Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo00Oooooo0_l0000Dooooo`03o`000?oooooooooo00Sooooo1?l00004ooooo`Co00000_ooool2
o`000004ooooool0003o0000o`0000Sooooo00?o0000ooooooooool0IOooool1o`0000004?ooool0
0ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`05ooooo`?o00001Oooool5o`0000;ooooo0_l000000ooooooo0000o`00000:
ooooo`03o`000?oooooooooo06Kooooo0Ol00000013ooooo00?o0000ooooooooool09oooool00ol0
003oooooooooo`0Oooooo`;o00004_ooool00ol0003oooooooooo`02ooooo`?o00001_ooool2o`00
0003ooooool0003o000000?ooooo00Co0000ooooool0003o00002_ooool2o`0006Wooooo0Ol00000
013ooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo
00oooooo00?o0000ooooool000000_l00007ooooo`;o00000_ooool01?l0003oooooooooooooool2
o`000003ooooool0003ooooo00[ooooo00?o0000ooooooooool0JOooool1o`0000004?ooool00ol0
003oooooooooo`0Xooooo`03o`000?oooooooooo027ooooo0_l0000?ooooo`;o00002?ooool2o`00
00;ooooo0_l00003ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool0J_ooool1
o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`05o`000?ooooooooooooooool000001_ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo01;ooooo1Ol00004ooooo`Oo00001oooool2
o`0000;ooooo0_l00004ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01?oo
ool1o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`05o`000?ooooooooooooooool000001_oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo0_l0000<ooooo`Go00001_oo
ool00ol0003oooooooooo`04ooooo`06o`000?ooooooooooooooool0003ooooo0_l000000ooooooo
0000o`000002ooooo`05o`000?ooooooooooooooool000001oooool01?l0003oooooooooool0000:
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`04
ooooo`7o00000008ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool01?l0
003oooooooooool00007ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`0Dooooo`05o`000?oooooo0000o`000?ooool00_l00003ooooo`03o`000?oo
oooo000000;ooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00Gooooo
00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool01Oooool1o`0000002?ooool00ol0003oooooooooo`05ooooo`?o0000
0oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2Oooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`04ooooo`So00001oooool2o`000003ooooool0003o000000?o
oooo1?l00002ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`05oooo
o`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Cooooo0ol0000000Sooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`05o`000?ooooooooooooooool000001_ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool04?ooool3o`000003ooooool0003o
oooo00?ooooo00?o0000ooooool000000oooool01Ol0003ooooooooooooooooo000000Cooooo00?o
0000ooooooooool01Oooool01?l0003oooooooooool0000:ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`06ooooo`7o00000008ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02Oooool01?l0003oooooooooool00007ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0>ooooo`03o`00
0?oooooooooo00;o00001?ooool00ol0003oooooo`000003ooooo`05o`000?ooooooooooooooool0
00001?ooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo0Ol0000000So
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`04o`000?ooooooooooo`00
00Oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Looooo`;o00001?ooool00ol0
003oooooooooo`03ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`05
ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo0Ol00000013ooooo00?o0000ooooooooool0:Oooool0
0ol0003oooooooooo`0_ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool00oooool0
1Ol0003ooooooooooooooooo000000gooooo00?o0000ooooooooool0L?ooool1o`0000004?ooool0
0ol0003oooooooooo`0Yooooo`03o`000?oooooooooo02gooooo0_l00002ooooo`04o`000?oooooo
ooooo`0000Gooooo00Go0000ooooooooooooooooo`00000=ooooo`03o`000?oooooooooo077ooooo
0Ol00000013ooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`0[ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooool000001_ooool01Ol0003ooooooooooooooooo000000cooooo
00?o0000ooooooooool0L_ooool1o`0000004?ooool00ol0003oooooooooo`0Zooooo`03o`000?oo
oooooooo02Wooooo0_l00005ooooo`;o00001_ooool01Ol0003ooooooooooooooooo000000cooooo
00?o0000ooooooooool0Loooool1o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Sooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02ooooo`;o00002_oo
ool2o`0000Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool01Oooool1o`0000004?ooool2o`0000Cooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo0_l0000H
ooooo`;o00001oooool2o`000003ooooool0003ooooo00;ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooo`00000:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01?ooool2
o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Cooooo0_l00007oooo
o`05o`000?oooooo0000ooooool000000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
000000[ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06ooooo`7o0000000@oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool4o`0000Kooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`02o`0000;ooooo00?o0000ooooooooool00oooool2o`00
00[ooooo0_l0000:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0Ol00000013ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`03ooooo`Co00002Oooool00ol0003oooooooooo`06ooooo`05
o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooo0000
00[ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`7o0000000@ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`06ooooo`04
o`000?ooooooooooooooo`;o00000_ooool00ol0003oooooooooo`03ooooo`;o00002_ooool2o`00
00[ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool1o`0000004?ooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Iooooo`;o
00002?ooool02Ol0003ooooooooooooooooo0000ooooool0003oooooo`000005ooooo`;o00002_oo
ool2o`0000[ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool1o`0000004?ooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooool000001?ooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo07Oooooo0Ol00000013ooooo00?o0000ooooooooool0;Oooool00ol0
003oooooooooo`0Kooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01?ooool2o`00
00Gooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`1hooooo`7o0000000@ooooo`03
o`000?oooooooooo02kooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Gooooo0_l00004ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool0N?ooool1o`0000004?ooool2o`0002oooooo00?o0000ooooooooool06?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo07Sooooo0_l00000013ooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`05ooooo`?o00000oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00Cooooo00Go0000ooooooooooooooooo`00000:ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Gooooo
0Ol00000013ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`;o00005ooo
ool00ol0003oooooo`000009ooooo`03o`000?oooooooooo00Kooooo0ol00002ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool01Oooool1o`0000004?ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooool000005Oooool00ol0003oooooo`000009
ooooo`;o00001oooool00ol0003oooooo`000003ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01Oooool1o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
00Oooooo0_l00007ooooo`Go00001oooool2o`000003ooooool0003ooooo00Sooooo0_l00008oooo
o`03o`000?oooooo000000;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06oooo
o`7o0000000@ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool2o`0000_o
oooo0ol00002ooooo`;o00000_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Ko
oooo00Co0000ooooool0003o00000_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Kooooo0Ol00000013ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`;o
00003_ooool01Ol0003ooooooooooooooooo000000[ooooo0_l00008ooooo`04o`000?oooooo0000
o`0000;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06ooooo`7o0000000@oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Oooool2o`0000_ooooo0_l00003oooo
o`03o`000?oooooooooo00Sooooo0_l00009ooooo`;o000000Coooooo`000?oooooo00001oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`7o0000000@ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool02oooool2o`0000Sooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`08oooo
o`07o`000?ooooooooooooooool0003oooooo`000007ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo0Ol0
0000013ooooo0_l0000fooooo`Wo00004?ooool00ol0003oooooooooo`08ooooo`04o`000?oooooo
ooooooooo`;o00003Oooool00ol0003oooooooooo`1looooo`;o0000000@ooooo`03o`000?oooooo
oooo04gooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`02ooooo`;o00003Oooool0
0ol0003oooooooooo`1mooooo`7o0000000@ooooo`03o`000?oooooooooo04gooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`02ooooo`;o00003?ooool00ol0003oooooooooo`1noooo
o`7o0000000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool09Oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00?ooooo0_l0000:ooooo`03o`000?oooooo000000So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`05ooooo`7o0000000@ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool08Oooool01Ol0003ooooooooooooooooo000000Ko
oooo00Go0000ooooooooooooooooo`000005ooooo`;o00002_ooool00ol0003oooooo`000008oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01Oooool1o`0000004?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0_l0000>ooooo`;o00002Oooool01?l0003o
ooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool3o`0000[ooooo0_l00009
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01Oooool1o`0000004?ooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02Oooool2o`00
00[ooooo00Go0000ooooooooooooooooo`000006ooooo`05o`000?ooooooooooooooool000001Ooo
ool2o`0000[ooooo00?o0000ooooool000002?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Kooooo0Ol00000013ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`;o00001oooool2o`0000_ooooo00Go0000ooooooooooooooooo`000007ooooo`05o`000?oo
ooooooooooooool000001Oooool2o`0000[ooooo00?o0000ooooool000002?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Kooooo0Ol00000013ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02ooo
ool01Ol0003ooooooooooooooooo000000Kooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooo000000[ooooo0_l00009ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool01_ooool1o`0000004?ooool2o`0000Gooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0?ooooo`05o`000?ooooooooooooooool000001oooool01Ol0003ooooo
oooooooooooo000000Gooooo0ol00009ooooo`03o`000?oooooo000000Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`06ooooo`;o0000000@ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool08?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool00oooool3o`0000Wooooo00?o0000ooooool000002?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Oooooo0Ol00000013ooooo00?o0000ooooooooool0B?oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo0000
2oooool00ol0003oooooooooo`20ooooo`7o0000000@ooooo`03o`000?oooooooooo04Sooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000[ooooo
00?o0000ooooooooool0POooool1o`0000004?ooool00ol0003oooooooooo`17ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool0000:ooooo`03o`00
0?oooooooooo087ooooo0Ol00000013ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo03Kooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`03ooooo`05o`000?ooooooooooooooool000002_ooool00ol0003oooooooooo`21ooooo`7o0000
000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool05oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooo000000[ooooo00?o0000ooooooooool00oooool01?l0003ooooooooo
ooooool2o`0000Wooooo0_l0000:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
1Oooool1o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01Oooooo00?o
0000ooooooooool01_ooool00ol0003oooooo`00000:ooooo`03o`000?oooooooooo00?ooooo00Co
0000oooooooooooooooo0_l00009ooooo`;o00002_ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo00Gooooo0Ol0000000Sooooo0ol00005ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool05Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo000000[ooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo0_l0
000:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool1o`0000002?ooool0
0ol0003oooooooooo`05ooooo`?o00001?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06ooooo`Oo00001oooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooo000000[ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo0_l0000:ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01?ooool3o`0000002Oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`06oooo
o`03o`000?oooooo000000_ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00Oooooo0_l0000:ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool01_ooool1o`0000002Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo000000[o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`;o00002Oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool1o`000000
1oooool3o`0000Kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0@ooooo`03o`00
0?oooooooooo00Sooooo0_l0000;ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
0_ooool2o`0000Sooooo0_l0000:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1oooool1o`0000004?ooool00ol0003oooooooooo`13ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool0Poooool1o`0000004?ooool00ol0003oooooooooo`13ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool0Poooool1o`0000004?ooool00ol0003oooooooooo`12oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0Poooool1o`0000004?ooool00ol0003o
ooooooooo`12ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0Q?ooool1o`000000
4?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo
00000oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00Go0000oooooooo
ooooooooo`00000:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool1o`00
00004?ooool2o`0000Cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool03?ooool2o`0000Wooooo00Go0000oooooooo
ooooooooo`000005ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo00000oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`00
000:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01Oooool2o`0000004?ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01_ooool0
1?l0003oooooooooool00002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Ooo
ool01?l0003oooooooooool0000:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1_ooool1o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Oooooo0_l0
000;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`05ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Cooooo00Go0000ooooooooooooooooo`00000:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool01_ooool1o`0000004?ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool01Oooool01?l0003oooooooooool00003ooooo`03
o`000?oooooooooo00Cooooo0_l00006ooooo`05o`000?ooooooooooooooool000002_ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo0Ol00000013ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooo
oooo00000oooool00ol0003oooooooooo`04ooooo`;o00001_ooool01?l0003oooooooooool0000:
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool1o`0000004?ooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo00000_ooool0
0ol0003oooooooooo`05ooooo`;o00001_ooool01?l0003oooooooooool0000:ooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool01oooool1o`0000004?ooool00ol0003oooooooooo`0o
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Q_ooool1o`0000004?ooool00ol0
003oooooooooo`0oooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Q_ooool1o`00
00004?ooool00ol0003oooooooooo`0nooooo`03o`000?oooooooooo00cooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool0Q_ooool1o`0000004?ooool2o`0003oooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`25ooooo`;o0000000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool01ooo
ool2o`0000Wooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`;o00002Ooo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0Ol00000013ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool05_ooool00ol0003oooooooooo`07ooooo`;o00002Oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00?ooooo0_l00009ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01_ooool1o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`05ooooo`;o00003Oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooo000000Wooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`03ooooo`;o00002Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Kooooo0Ol00000013ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Wooooo00?o0000ooooooooool01oooool2o`0000[ooooo00?o0000oooooooo
ool02?ooool2o`0000[ooooo00Go0000ooooooooooooooooo`000006ooooo`;o00002Oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0Ol00000013ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02Oooool2o`0000Sooooo00?o0000ooooooooool02?ooool2o`0000Wooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`03ooooo`;o00002Oooool2o`0000Cooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01oooool1o`0000004?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool02?ooool00ol0003oooooo`000009ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool00oooool2o`0000Wooooo0_l00003ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo
0Ol00000013ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`09ooooo`;o00002_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo0_l00009ooooo`;o00000ooo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`07ooooo`7o0000000@ooooo`03o`000?oooooooooo03_ooooo00?o0000
ooooooooool03?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Sooooo00Go0000
ooooooooooooooooo`00002:ooooo`7o0000000@ooooo`;o0000??ooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02Oooool01Ol0003ooooooooooooo
oooo000008Wooooo0_l00000013ooooo00?o0000ooooooooool0>_ooool00ol0003oooooooooo`0=
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02Oooool01Ol0003ooooooooooooo
oooo000008[ooooo0Ol00000013ooooo00?o0000ooooooooool0>_ooool00ol0003oooooooooo`0=
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02Oooool01?l0003oooooooooool0
002;ooooo`7o0000000@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool01_ooool0
0ol0003oooooo`00000:ooooo`04o`000?ooooooooooo`0000Kooooo0_l0000:ooooo`04o`000?oo
ooooooooo`0000Oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Kooooo0Ol00000013ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool05Oooool00ol0003ooooooooo
o`05ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooool000001_ooool00ol0003ooooo
o`00000:ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0Ol00000013ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
4oooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooool0
00001_ooool00ol0003oooooo`00000:ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0Ol00000013o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02?ooool4o`0000Oooooo00?o0000ooooooooool01_ooool00ol0003o
ooooo`00000;ooooo`03o`000?oooooo000000Kooooo00?o0000ooooool000002_ooool01?l0003o
ooooooooool00007ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`06ooooo`7o0000000@ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Gooooo0ol0000;ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooool000002_ooool01?l0003oooooooooool00006oooo
o`;o00002_ooool2o`0000;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool1o`0000004?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo00002_ooool01?l0
003oooooooooool00006ooooo`;o00002_ooool2o`000003ooooool0003ooooo00Kooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo0Ol00000
013ooooo0_l00005ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo00Kooooo00?o0000ooooool000002oooool00ol0
003oooooo`000006ooooo`03o`000?oooooo000000[ooooo0_l000000ooooooo0000ooooo`06oooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06oooo
o`;o0000000@ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`0Vooooo`03o`000?oooooo000000_ooooo00?o0000ooooool000001_ooool00ol0003o
ooooo`00000:ooooo`;o000000?oooooo`000?ooool01_ooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool1o`0000004?ooool00ol0003ooooo
ooooo`0gooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooo000008cooooo0Ol00000013ooooo00?o0000ooooooooool0=ooo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02ooo
ool00ol0003oooooo`00002<ooooo`7o0000000@ooooo`03o`000?oooooooooo03Oooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooool00000S?ooool1o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool02?ooool2o`0000Gooooo00Go0000ooooooooooooooooo`00000:
ooooo`;o00002Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01_ooool1o`0000004?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo000000[ooooo0_l00009
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06
ooooo`7o00000007ooooo`?o00001_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo000000[ooooo0_l00009
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06
ooooo`7o00000009ooooo`03o`000?oooooooooo00Cooooo0ol00003ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo000000[ooooo0_l00009
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`04
ooooo`?o00000009ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`08ooooo`;o00001_ooool01?l0003oooooooooool0000:ooooo`?o00002?ooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool1
o`0000002Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool02?ooool2o`0000Kooooo00Co0000oooooooooooo00002_ooool3o`0000Sooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo0Ol00000
00Oooooo0ol00006ooooo`03o`000?oooooooooo00?ooooo0_l0000:ooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0:ooooo`;o00001?ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01?ooool01Ol0
003ooooooooooooooooo000000[ooooo0_l00009ooooo`03o`000?oooooooooo00Wooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool02?ooool2o`0000Sooooo0Ol00000013ooooo00?o0000ooooooooool00oooool2o`00
00Oooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool01Oooool2o`0000?ooooo00?o0000ooooooooool00_ooool2
o`0000Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo000000?ooooo00Co
0000oooooooooooo00001oooool2o`0000Sooooo0_l00007ooooo`05o`000?ooooooooooooooool0
00001?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo000000Sooooo00?o0000oooooooo
ool01_ooool00ol0003oooooo`000006ooooo`05o`000?ooooooooooooooool000001?ooool00ol0
003oooooooooo`03ooooo`04o`000?ooooooooooo`0000Sooooo00?o0000ooooooooool01_ooool0
0ol0003oooooo`000006ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooooooo
o`03ooooo`04o`000?ooooooooooo`0000Oooooo0_l00008ooooo`7o0000000@oooooo3o00000000
\
\>"],
  ImageRangeCache->{{{0, 255.875}, {201.25, 0}} -> {-2.5106, -1.39042, \
0.0223716, 0.0223716}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Implementation of SlopeLines"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Stan Wagon's Code for Generating Field Lines"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Null\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(SlopeLines::"\<usage\>" = \
"\<SlopeLines[f,length,{t,t0,t1,dt},{y,y0,y1,dy}] gives an array of lines \
showing the solutions to the differential equation dy/dt = f. The lengths of \
the slope lines at each grid point are given by length; t0, t1, and dt give \
the range {t0 to t1}and step-size for the t-values, and similarly for the \
y-values.\>";\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(SlopeLines[f_, length_, {t_, t0_, t1_, dt_}, {y_, y0_, y1_, dy_}] := 
      Module[{unitSlope, u, s, temp}, 
        unitSlope[tt_, 
            yy_] := \((temp = N[f /. {t \[Rule] tt, y \[Rule] yy}]; 
            If[temp == 0, {0, 0}, \(s = {1, temp}\)\/\@\(s . s\)])\); 
        Show[Graphics[{Thickness[ .0005], 
              Table[Line[{{tt, yy} - 
                      1\/2\ \((u = unitSlope[tt, yy])\)\ length, {tt, 
                        yy} + \(u\ length\)\/2}], {tt, N[t0], t1, 
                  N[dt]}, {yy, N[y0], y1, N[dy]}]}], Axes \[Rule] Automatic, 
          AspectRatio \[Rule] Automatic, PlotRange \[Rule] All]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{535, 509},
WindowMargins->{{171, Automatic}, {Automatic, 102}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Info3279866828-6568912"->{
    Cell[2969, 101, 388, 6, 103, "Print",
      CellTags->"Info3279866828-6568912"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Info3279866828-6568912", 376683, 10195}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 146, 4, 82, "Subtitle",
  Evaluatable->False],
Cell[1925, 59, 253, 5, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2203, 68, 125, 2, 69, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2353, 74, 110, 2, 42, "Input"],
Cell[2466, 78, 84, 1, 42, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[2599, 85, 96, 2, 69, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2720, 91, 109, 2, 28, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2854, 97, 112, 2, 27, "Input"],
Cell[2969, 101, 388, 6, 103, "Print",
  CellTags->"Info3279866828-6568912"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[3406, 113, 108, 2, 28, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3539, 119, 174, 5, 43, "Input"],
Cell[3716, 126, 104139, 2605, 239, 23517, 1604, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[107892, 2736, 69, 1, 27, "Input"],
Cell[107964, 2739, 101910, 2775, 208, 27010, 1846, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[209935, 5521, 105, 2, 69, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[210065, 5527, 115, 2, 28, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[210205, 5533, 339, 9, 42, "Input"],
Cell[210547, 5544, 213, 4, 45, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[210809, 5554, 105, 2, 28, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[210939, 5560, 108, 2, 27, "Input"],
Cell[211050, 5564, 180, 3, 45, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[211279, 5573, 118, 2, 28, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[211422, 5579, 195, 4, 44, "Input"],
Cell[211620, 5585, 1126, 16, 235, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[212807, 5608, 102, 2, 69, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[212934, 5614, 164, 4, 43, "Input"],
Cell[213101, 5620, 43953, 1303, 183, 20251, 1005, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[257103, 6929, 94, 2, 69, "Section",
  Evaluatable->False],
Cell[257200, 6933, 285, 8, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[257510, 6945, 147, 3, 43, "Input"],
Cell[257660, 6950, 116550, 3173, 211, 31124, 2112, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[374259, 10129, 105, 2, 69, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[374389, 10135, 124, 2, 38, "Subsection",
  Evaluatable->False],
Cell[374516, 10139, 63, 2, 27, "Input"],
Cell[374582, 10143, 441, 8, 155, "Input",
  InitializationCell->True],
Cell[375026, 10153, 721, 13, 328, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

